/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedCubeFace;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubeTypes;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.face.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.face.SkinCuller;
import moe.plushie.armourers_workshop.core.skin.painting.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.math.OpenRay;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.TexturePos;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.texture.PlayerTextureModel;
import moe.plushie.armourers_workshop.utils.texture.SkinPaintData;
import moe.plushie.armourers_workshop.utils.texture.SkinPreviewData;
import moe.plushie.armourers_workshop.utils.texture.SkyBox;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class BakedCubeQuads {
    private final HashMap<Direction, ArrayList<BakedCubeFace>> dirFaces = new HashMap();
    private final HashMap<RenderType, ArrayList<BakedCubeFace>> splitFaces = new HashMap();
    private final Rectangle3i bounds;
    private final ISkinTransform transform;
    private final OpenVoxelShape renderShape;
    private final ColorDescriptor colorInfo = new ColorDescriptor();
    private int faceTotal = 0;

    public BakedCubeQuads(Rectangle3i bounds, ISkinTransform transform, OpenVoxelShape renderShape, Collection<SkinCubeFace> faces) {
        this.bounds = bounds;
        this.transform = transform;
        this.renderShape = renderShape;
        this.loadFaces(faces);
    }

    public static QuadsList<ISkinPartType> from(SkinPart part) {
        QuadsList<ISkinPartType> quads = new QuadsList<ISkinPartType>();
        SkinCubes data = part.getCubeData();
        OpenVoxelShape shape = data.getShape();
        Rectangle3i bounds = new Rectangle3i(shape.bounds());
        SkinCuller.cullFaces2(data, bounds, part.getType()).forEach((? super T result) -> {
            Rectangle3i newBounds = bounds;
            SkinTransform newTransform = SkinTransform.createTranslateTransform(new Vector3f(result.getOrigin()));
            OpenVoxelShape newRenderShape = shape;
            if (result.getPartType() != part.getType()) {
                newBounds = result.getBounds().offset(bounds.getOrigin());
                newRenderShape = OpenVoxelShape.box(new Rectangle3f(newBounds));
            }
            quads.add(result.getPartType(), new BakedCubeQuads(newBounds, newTransform, newRenderShape, result.getFaces()));
        });
        return quads;
    }

    public static QuadsList<ISkinPartType> from(SkinPreviewData previewData) {
        QuadsList<ISkinPartType> allQuads = new QuadsList<ISkinPartType>();
        if (previewData == null) {
            return allQuads;
        }
        previewData.forEach((ISkinTransform transform, SkinCubes data) -> {
            OpenVoxelShape shape = data.getShape();
            Rectangle3i bounds = new Rectangle3i(shape.bounds());
            SkinCuller.cullFaces2(data, bounds, SkinPartTypes.BLOCK).forEach((? super T result) -> {
                BakedCubeQuads quad = new BakedCubeQuads(bounds, (ISkinTransform)transform, shape, (Collection<SkinCubeFace>)result.getFaces());
                allQuads.add(result.getPartType(), quad);
            });
        });
        return allQuads;
    }

    public static QuadsList<ISkinPartType> from(SkinPaintData paintData) {
        QuadsList<ISkinPartType> allQuads = new QuadsList<ISkinPartType>();
        if (paintData == null) {
            return allQuads;
        }
        for (Map.Entry entry : PlayerTextureModel.of(paintData.getWidth(), paintData.getHeight(), false).entrySet()) {
            SkyBox box = (SkyBox)entry.getValue();
            ArrayList<SkinCubeFace> quads = new ArrayList<SkinCubeFace>();
            box.forEach((TexturePos texture, int x, int y, int z, Direction dir) -> {
                PaintColor paintColor = PaintColor.of(paintData.getColor(texture));
                if (paintColor.getPaintType() == SkinPaintTypes.NONE) {
                    return;
                }
                Rectangle3f shape = new Rectangle3f(x, y, z, 1.0f, 1.0f, 1.0f);
                SkinTransform transform = SkinTransform.IDENTITY;
                quads.add(new SkinCubeFace(shape, transform, paintColor, 255, dir, null, SkinCubeTypes.SOLID));
            });
            if (quads.size() == 0) continue;
            Rectangle3i bounds = box.getBounds();
            OpenVoxelShape renderShape = OpenVoxelShape.box(new Rectangle3f(bounds));
            allQuads.add((ISkinPartType)entry.getKey(), new BakedCubeQuads(bounds, SkinTransform.IDENTITY, renderShape, quads));
        }
        return allQuads;
    }

    public void forEach(BiConsumer<RenderType, ArrayList<BakedCubeFace>> action) {
        this.splitFaces.forEach(action);
    }

    public void forEach(OpenRay ray, Consumer<BakedCubeFace> recorder) {
        if (this.dirFaces.isEmpty()) {
            this.loadDirFaces();
        }
        this.dirFaces.forEach((? super K dir, ? super V faces) -> {
            for (BakedCubeFace face : faces) {
                if (!face.intersects(ray)) continue;
                recorder.accept(face);
            }
        });
    }

    private void loadFaces(Collection<SkinCubeFace> faces) {
        for (SkinCubeFace skinCubeFace : faces) {
            if (skinCubeFace.getPaintType() == SkinPaintTypes.NONE) continue;
            BakedCubeFace bakedFace = new BakedCubeFace(skinCubeFace);
            this.addSplitFace(bakedFace.getRenderType(), bakedFace);
            if (bakedFace.getRenderTypeVariants() != null) {
                bakedFace.getRenderTypeVariants().forEach((? super T renderType) -> this.addSplitFace((RenderType)renderType, bakedFace));
            }
            this.colorInfo.add(skinCubeFace.getColor());
            ++this.faceTotal;
        }
        for (ArrayList arrayList : this.splitFaces.values()) {
            arrayList.sort(Comparator.comparingInt(f -> f.getDirection().func_176745_a()));
        }
    }

    private void loadDirFaces() {
        this.splitFaces.values().forEach((? super T faces) -> faces.forEach((? super E face) -> this.dirFaces.computeIfAbsent(face.getDirection(), k -> new ArrayList()).add(face)));
    }

    private void addSplitFace(RenderType renderType, BakedCubeFace bakedFace) {
        this.splitFaces.computeIfAbsent(renderType, k -> new ArrayList()).add(bakedFace);
    }

    public ColorDescriptor getColorInfo() {
        return this.colorInfo;
    }

    public Rectangle3i getBounds() {
        return this.bounds;
    }

    public ISkinTransform getTransform() {
        return this.transform;
    }

    public OpenVoxelShape getRenderShape() {
        return this.renderShape;
    }

    public int getFaceTotal() {
        return this.faceTotal;
    }

    public static class QuadsList<T> {
        private final ArrayList<Pair<T, BakedCubeQuads>> quads = new ArrayList();

        public void add(T partType, BakedCubeQuads quad) {
            this.quads.add(Pair.of(partType, (Object)quad));
        }

        public void forEach(BiConsumer<T, BakedCubeQuads> consumer) {
            this.quads.forEach((Consumer<Pair<T, BakedCubeQuads>>)((Consumer<Pair>)pair -> consumer.accept(pair.getKey(), (BakedCubeQuads)pair.getValue())));
        }
    }
}

