/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.action.ICanHeld;
import moe.plushie.armourers_workshop.api.action.ICanUse;
import moe.plushie.armourers_workshop.api.client.IBakedSkin;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemModel;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.data.cache.SkinCache;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.data.transform.SkinPartTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinWingsTransform;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinUtils;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedSkin
implements IBakedSkin {
    private final int id = ThreadUtils.BAKED_SKIN_COUNTER.incrementAndGet();
    private final String identifier;
    private final Skin skin;
    private final ISkinType skinType;
    private final HashMap<Object, Rectangle3f> cachedBounds = new HashMap();
    private final HashMap<BlockPos, Rectangle3i> cachedBlockBounds = new HashMap();
    private final ArrayList<SkinWingsTransform> cachedWingsTransforms = new ArrayList();
    private final ArrayList<BakedItemTransform> cachedItemTransforms = new ArrayList();
    private final Range<Integer> useTickRange;
    private final List<BakedSkinPart> skinParts;
    private final ColorDescriptor colorDescriptor;
    private final SkinUsedCounter usedCounter;
    private final ColorScheme colorScheme;
    private final BakedItemModel resolvedItemModel;
    private final HashMap<Integer, ColorScheme> resolvedColorSchemes = new HashMap();

    public BakedSkin(String identifier, ISkinType skinType, ArrayList<BakedSkinPart> bakedParts, Skin skin, ColorScheme colorScheme, ColorDescriptor colorDescriptor, SkinUsedCounter usedCounter) {
        this.identifier = identifier;
        this.skin = skin;
        this.skinType = skinType;
        this.skinParts = bakedParts;
        this.colorScheme = colorScheme;
        this.colorDescriptor = colorDescriptor;
        this.usedCounter = usedCounter;
        this.useTickRange = this.getUseTickRange(bakedParts);
        this.resolvedItemModel = this.resolveItemModel(skin.getItemTransforms());
        this.loadBlockBounds();
        this.loadPartTransforms();
    }

    public void setupAnim(Entity entity, float partialTicks, SkinItemSource itemSource) {
        this.cachedItemTransforms.forEach(it -> it.setup(entity, itemSource));
        this.cachedWingsTransforms.forEach(it -> it.setup(entity, partialTicks));
    }

    public ColorScheme resolve(Entity entity, ColorScheme scheme) {
        if (this.colorDescriptor.isEmpty()) {
            return ColorScheme.EMPTY;
        }
        ColorScheme resolvedColorScheme = this.resolvedColorSchemes.computeIfAbsent(entity.func_145782_y(), k -> this.colorScheme.copy());
        if (PlaceholderManager.isPlaceholder(entity)) {
            ResourceLocation resolvedTexture = PlayerTextureLoader.getInstance().getTextureLocation(entity);
            if (!Objects.equals(resolvedColorScheme.getTexture(), resolvedTexture)) {
                resolvedColorScheme.setTexture(resolvedTexture);
            }
        }
        resolvedColorScheme.setReference(scheme);
        return resolvedColorScheme;
    }

    public int getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public ISkinType getType() {
        return this.skinType;
    }

    public List<BakedSkinPart> getParts() {
        return this.skinParts;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public ColorDescriptor getColorDescriptor() {
        return this.colorDescriptor;
    }

    @Nullable
    public BakedItemModel getItemModel() {
        return this.resolvedItemModel;
    }

    public SkinUsedCounter getUsedCounter() {
        return this.usedCounter;
    }

    public HashMap<BlockPos, Rectangle3i> getBlockBounds() {
        return this.cachedBlockBounds;
    }

    public Rectangle3f getRenderBounds(SkinItemSource itemSource) {
        Vector3f rotation = itemSource.getRotation();
        Object key = SkinCache.borrowKey(new Object[]{rotation, itemSource.getTransformType()});
        Rectangle3f bounds = this.cachedBounds.get(key);
        if (bounds != null) {
            SkinCache.returnKey(key);
            return bounds;
        }
        Entity entity = (Entity)PlaceholderManager.MANNEQUIN.get();
        OpenMatrix4f matrix = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
        OpenVoxelShape shape = this.getRenderShape(entity, BakedArmature.defaultBy(this.skinType), itemSource);
        if (rotation != null) {
            matrix.rotate(new OpenQuaternionf(rotation.getX(), rotation.getY(), rotation.getZ(), true));
            shape.mul(matrix);
        }
        bounds = shape.bounds().copy();
        if (rotation != null) {
            Vector4f center = new Vector4f(bounds.getCenter());
            matrix.invert();
            center.transform(matrix);
            bounds.setX(center.x() - bounds.getWidth() / 2.0f);
            bounds.setY(center.y() - bounds.getHeight() / 2.0f);
            bounds.setZ(center.z() - bounds.getDepth() / 2.0f);
        }
        this.cachedBounds.put(key, bounds);
        return bounds;
    }

    public OpenVoxelShape getRenderShape(Entity entity, BakedArmature armature, SkinItemSource itemSource) {
        if (armature == null) {
            return OpenVoxelShape.empty();
        }
        SkinRenderContext context = new SkinRenderContext();
        context.setReferenced(itemSource);
        context.setTransformType(itemSource.getTransformType());
        this.setupAnim(entity, 0.0f, context.getReferenced());
        return SkinRenderer.getShape(entity, armature, this, context);
    }

    public <T extends Entity> boolean shouldRenderPart(T entity, BakedSkinPart bakedPart, SkinRenderContext context) {
        ISkinPartType partType = bakedPart.getType();
        if (partType == SkinPartTypes.ITEM_FISHING_HOOK) {
            return this.isHookEntity(entity);
        }
        if (partType == SkinPartTypes.ITEM_FISHING_ROD1) {
            PlayerEntity player = ObjectUtils.safeCast(entity, PlayerEntity.class);
            return player != null && player.field_71104_cf != null;
        }
        if (partType == SkinPartTypes.ITEM_FISHING_ROD) {
            if (this.isHookEntity(entity)) {
                return false;
            }
            PlayerEntity player = ObjectUtils.safeCast(entity, PlayerEntity.class);
            return player == null || player.field_71104_cf == null;
        }
        if (partType == SkinPartTypes.ITEM_ARROW) {
            if (this.isArrowEntity(entity)) {
                return true;
            }
            if (context.getTransformType() == AbstractItemTransformType.NONE) {
                return this.skinParts.size() == 1;
            }
            return false;
        }
        if (this.isArrowEntity(entity)) {
            return false;
        }
        if (this.isHookEntity(entity)) {
            return false;
        }
        if (partType instanceof ICanUse && entity instanceof LivingEntity) {
            int useTick = this.getUseTick((LivingEntity)entity, context.getReferenced().getItem());
            Range<Integer> useRange = ((ICanUse)((Object)partType)).getUseRange();
            return useRange.contains((Comparable)Integer.valueOf(MathUtils.clamp(useTick, (Integer)this.useTickRange.lowerEndpoint(), (Integer)this.useTickRange.upperEndpoint())));
        }
        return true;
    }

    private boolean isHookEntity(Entity entity) {
        return entity instanceof FishingBobberEntity;
    }

    private boolean isArrowEntity(Entity entity) {
        if (entity instanceof TridentEntity) {
            return false;
        }
        return entity instanceof AbstractArrowEntity;
    }

    private void loadPartTransforms() {
        this.skinParts.forEach(part -> {
            SkinPartTransform transform = part.getTransform();
            if (part.getType() instanceof ICanHeld) {
                transform.insertTransform(new BakedItemTransform((BakedSkinPart)part, this), 0);
            }
        });
        this.skinParts.forEach(it -> it.getTransform().forEach(transform -> {
            if (transform instanceof SkinWingsTransform) {
                this.cachedWingsTransforms.add((SkinWingsTransform)transform);
            }
            if (transform instanceof BakedItemTransform) {
                this.cachedItemTransforms.add((BakedItemTransform)transform);
            }
        }));
    }

    private void loadBlockBounds() {
        if (this.skinType != SkinTypes.BLOCK) {
            return;
        }
        for (BakedSkinPart skinPart : this.skinParts) {
            HashMap<BlockPos, Rectangle3i> bm = skinPart.getPart().getBlockBounds();
            if (bm == null) continue;
            this.cachedBlockBounds.putAll(bm);
        }
    }

    private int getUseTick(LivingEntity entity, ItemStack itemStack) {
        if (entity.func_184607_cu() == itemStack) {
            return entity.func_184612_cw();
        }
        if (CrossbowItem.func_220012_d((ItemStack)itemStack)) {
            return 100;
        }
        return 0;
    }

    private Range<Integer> getUseTickRange(ArrayList<BakedSkinPart> bakedParts) {
        int count = 0;
        int maxUseTick = Integer.MIN_VALUE;
        int minUseTick = Integer.MAX_VALUE;
        for (BakedSkinPart bakedPart : bakedParts) {
            ISkinPartType partType = bakedPart.getType();
            if (!(partType instanceof ICanUse)) continue;
            Range<Integer> range = ((ICanUse)((Object)partType)).getUseRange();
            maxUseTick = Math.max(maxUseTick, (Integer)range.upperEndpoint());
            minUseTick = Math.min(minUseTick, (Integer)range.lowerEndpoint());
            ++count;
        }
        if (count == 0) {
            return Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        }
        return Range.closed((Comparable)Integer.valueOf(minUseTick), (Comparable)Integer.valueOf(maxUseTick));
    }

    private BakedItemModel resolveItemModel(SkinItemTransforms oldValue) {
        if (oldValue != null) {
            return BakedItemModel.from(this.resolveItemOverrides(), oldValue, false);
        }
        return null;
    }

    private Collection<String> resolveItemOverrides() {
        ArrayList<String> overrides = new ArrayList<String>();
        for (BakedSkinPart part : this.skinParts) {
            overrides.addAll(SkinUtils.getItemOverrides(part.getType()));
        }
        return overrides;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BakedSkin bakedSkin = (BakedSkin)o;
        return this.identifier.equals(bakedSkin.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

