/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIButton;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIImageView;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIView;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.library.ISkinLibrary;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.client.gui.widget.ConfirmDialog;
import moe.plushie.armourers_workshop.core.client.gui.widget.SkinFileList;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import net.minecraft.util.Util;

public class FileProviderDialog
extends ConfirmDialog {
    private final SkinFileList fileList = new SkinFileList(new CGRect(0.0f, 0.0f, 100.0f, 100.0f));
    private final File rootPath;
    private final String extension;
    private FileItem selectedFile;
    private String selectedPath;

    public FileProviderDialog(File rootPath, String extension) {
        this.rootPath = rootPath;
        this.extension = extension;
        this.setFrame(new CGRect(0.0f, 0.0f, 240.0f, 200.0f));
        this.setTitle(NSString.localizedString("skin-library.dialog.fileProvider.title", new Object[0]));
        this.setMessage(NSString.localizedString("skin-library.dialog.fileProvider.message", extension));
        this.setup(this.bounds());
    }

    private void setup(CGRect rect) {
        CGPoint messageOffset = this.messageLabel.center().copy();
        messageOffset.y -= 10.0f;
        this.messageLabel.setCenter(messageOffset);
        this.fileList.setFrame(rect.insetBy(40.0f, 10.0f, 40.0f, 10.0f));
        this.fileList.setAutoresizingMask(18);
        this.fileList.addTarget(this, UIControl.Event.VALUE_CHANGED, FileProviderDialog::selectFile);
        this.addSubview(this.fileList);
        this.confirmButton.setTooltip(NSString.localizedString("skin-library.dialog.fileProvider.tooltip", this.extension), 4);
        this.confirmButton.setEnabled(false);
        this.selectPath("");
    }

    private void setupEmptyView() {
        CGRect rect = this.fileList.bounds();
        UIView emptyView = new UIView(this.fileList.frame());
        emptyView.setAutoresizingMask(this.fileList.autoresizingMask());
        UIImageView bg1 = new UIImageView(rect);
        bg1.setImage(UIImage.of(ModTextures.LIST).fixed(11.0f, 11.0f).clip(1.0f, 1.0f, 1.0f, 1.0f).build());
        bg1.setAutoresizingMask(18);
        emptyView.addSubview(bg1);
        float top = (rect.height - 50.0f) / 2.0f;
        UILabel titleView = new UILabel(new CGRect(10.0f, top, rect.width - 20.0f, 30.0f));
        titleView.setText(NSString.localizedString("skin-library.dialog.fileProvider.emptyFolder", new Object[]{this.extension, this.rootPath.getName()}));
        titleView.setTextColor(UIColor.GRAY);
        titleView.setAutoresizingMask(34);
        titleView.setTextHorizontalAlignment(NSTextAlignment.Horizontal.CENTER);
        titleView.setTextVerticalAlignment(NSTextAlignment.Vertical.TOP);
        titleView.setNumberOfLines(0);
        emptyView.addSubview(titleView);
        UIButton openButton = new UIButton(new CGRect((rect.width - 100.0f) / 2.0f, top + 30.0f, 100.0f, 20.0f));
        openButton.setTitle(NSString.localizedString("skin-library.dialog.fileProvider.openFolder", new Object[0]), 7);
        openButton.setTitleColor(UIColor.WHITE, 7);
        openButton.setBackgroundImage(ModTextures.defaultButtonImage(), 7);
        openButton.setAutoresizingMask(13);
        openButton.addTarget(this, UIControl.Event.MOUSE_LEFT_DOWN, FileProviderDialog::openFolder);
        emptyView.addSubview(openButton);
        this.addSubview(emptyView);
    }

    private void selectFile(UIControl control) {
        FileItem newValue;
        FileItem oldValue = this.selectedFile;
        this.selectedFile = newValue = (FileItem)this.fileList.getSelectedItem();
        this.confirmButton.setEnabled(newValue != null && !newValue.isDirectory());
        if (newValue != null && newValue.isDirectory() && oldValue == newValue) {
            this.selectPath(newValue.path);
        }
    }

    private void selectPath(String newSelectedPath) {
        if (Objects.equals(this.selectedPath, newSelectedPath)) {
            return;
        }
        this.selectedPath = newSelectedPath;
        File targetPath = new File(this.rootPath, this.selectedPath);
        ArrayList<FileItem> items = this.getSkinFiles(targetPath, false);
        String path = SkinFileUtils.getRelativePath(targetPath, this.rootPath, true);
        if (path != null && !path.equals("/")) {
            items.add(0, new FileItem("..", newSelectedPath + "/..", true));
        }
        this.fileList.reloadData(new ArrayList<ISkinLibrary.Entry>(items));
        if (items.isEmpty()) {
            this.setupEmptyView();
        }
    }

    private void openFolder(UIControl sender) {
        Util.func_110647_a().func_195641_a(this.rootPath);
    }

    public File getSelectedFile() {
        if (this.selectedFile == null || this.selectedFile.isDirectory()) {
            return null;
        }
        return new File(this.rootPath, this.selectedFile.getPath());
    }

    private ArrayList<FileItem> getSkinFiles(File directory, boolean recursive) {
        File[] templateFiles;
        ArrayList<FileItem> fileList = new ArrayList<FileItem>();
        try {
            templateFiles = directory.listFiles();
            if (templateFiles == null) {
                return fileList;
            }
        }
        catch (Exception e) {
            ModLog.error(this.extension + "file list load failed.", new Object[0]);
            e.printStackTrace();
            return fileList;
        }
        for (File file : templateFiles) {
            String path = SkinFileUtils.getRelativePath(file, this.rootPath, true);
            String filename = file.getName();
            if (file.isDirectory()) {
                fileList.add(new FileItem(filename, path, true));
                continue;
            }
            if (!filename.toLowerCase().endsWith(this.extension)) continue;
            String name = SkinFileUtils.getBaseName(filename);
            fileList.add(new FileItem(name, path, false));
        }
        Collections.sort(fileList);
        if (recursive) {
            for (File file : templateFiles) {
                if (!file.isDirectory()) continue;
                fileList.addAll(this.getSkinFiles(file, true));
            }
        }
        return fileList;
    }

    public static class FileItem
    implements Comparable<FileItem>,
    ISkinLibrary.Entry {
        private final String name;
        private final String path;
        private final boolean isDirectory;

        public FileItem(String name, String path, boolean isDirectory) {
            this.name = name;
            this.path = path;
            this.isDirectory = isDirectory;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getSkinIdentifier() {
            return null;
        }

        @Override
        public ISkinType getSkinType() {
            return null;
        }

        @Override
        public boolean isDirectory() {
            return this.isDirectory;
        }

        @Override
        public boolean isPrivateDirectory() {
            return false;
        }

        @Override
        public int compareTo(FileItem o) {
            if (this.isDirectory & !o.isDirectory) {
                return this.path.compareToIgnoreCase(o.path) - 1000000;
            }
            if (!this.isDirectory & o.isDirectory) {
                return this.path.compareToIgnoreCase(o.path) + 1000000;
            }
            return this.path.compareToIgnoreCase(o.path);
        }
    }
}

