/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.MathUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InventoryBox
extends UIControl {
    protected NSString message;
    protected CGPoint offset = new CGPoint(0.0f, 0.0f);
    protected CGSize itemSize = new CGSize(10.0f, 10.0f);
    private CGPoint mouseOffset = CGPoint.ZERO;

    public InventoryBox(CGRect frame) {
        super(frame);
    }

    @Override
    public void mouseDown(UIEvent event) {
        super.mouseDown(event);
        this.offset = event.locationInView(this);
        this.sendEvent(UIControl.Event.VALUE_CHANGED);
    }

    @Override
    public void mouseMoved(UIEvent event) {
        super.mouseMoved(event);
        this.mouseOffset = event.locationInView(this);
    }

    @Override
    public void render(CGPoint point, CGGraphicsContext context) {
        super.render(point, context);
        int u = 176;
        int v = 0;
        float width = this.bounds().width;
        float height = this.bounds().height;
        float hoverWidth = MathUtils.clamp(this.mouseOffset.x, 0.0f, width);
        float hoverHeight = MathUtils.clamp(this.mouseOffset.y, 0.0f, height);
        int iy = 0;
        while ((float)iy < height) {
            int ix = 0;
            while ((float)ix < width) {
                int iu = u;
                if ((float)ix <= this.offset.x && (float)iy <= this.offset.y) {
                    iu = (int)((float)iu + this.itemSize.width);
                }
                int iv = v;
                if ((float)ix <= hoverWidth && (float)iy <= hoverHeight && this.isHighlighted()) {
                    iv = (int)((float)iv + this.itemSize.height);
                }
                context.drawImage(ModTextures.ARMOURER, ix, iy, this.itemSize.width, this.itemSize.height, iu, iv, 256.0f, 256.0f);
                ix = (int)((float)ix + this.itemSize.width);
            }
            iy = (int)((float)iy + this.itemSize.height);
        }
    }

    public CGPoint getOffset() {
        return this.offset;
    }

    public void setOffset(CGPoint offset) {
        this.offset = offset;
    }

    public NSString message() {
        return this.message;
    }

    public void setMessage(NSString message) {
        this.message = message;
    }

    public CGSize getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(CGSize itemSize) {
        this.itemSize = itemSize;
    }
}

