/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSString;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.DelegateImpl;
import com.apple.library.impl.SoundManagerImpl;
import com.apple.library.impl.StateValueImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIFont;
import com.apple.library.uikit.UIImage;
import com.apple.library.uikit.UIMenuController;
import com.apple.library.uikit.UIMenuControllerDelegate;
import com.apple.library.uikit.UIMenuItem;
import com.apple.library.uikit.UIScrollView;
import java.util.Collection;
import java.util.HashMap;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeNode;
import moe.plushie.armourers_workshop.core.client.gui.widget.TreeViewDelegate;
import moe.plushie.armourers_workshop.init.ModTextures;
import moe.plushie.armourers_workshop.utils.ObjectUtils;

public class TreeView
extends UIScrollView
implements UIMenuControllerDelegate {
    protected final TreeNode rootNode;
    protected final HashMap<String, Entry> entries = new HashMap();
    protected boolean dirt = true;
    protected UIMenuController menuController;
    protected TreeNode selectedNode = null;
    protected UIMenuController currentMenuController;
    protected final DelegateImpl<TreeViewDelegate> delegate = DelegateImpl.of(new TreeViewDelegate(){});

    public TreeView(CGRect frame) {
        this(new TreeNode("Root"), frame);
    }

    public TreeView(TreeNode rootNode, CGRect frame) {
        super(frame);
        this.rootNode = rootNode;
        this.rootNode.link(this);
    }

    public TreeNode rootNode() {
        return this.rootNode;
    }

    public TreeNode selectedNode() {
        return this.selectedNode;
    }

    public void selectNode(TreeNode node) {
        if (this.selectedNode != null) {
            this.deselectNode(this.selectedNode);
        }
        this.hideNodeMenuIfNeeded();
        this.selectedNode = node;
        for (Entry entry : this.entries.values()) {
            if (entry.node != node) continue;
            entry.setSelected(true);
        }
        this.delegate.invoker().treeViewDidSelect(this, node);
    }

    public void deselectNode(TreeNode node) {
        this.hideNodeMenuIfNeeded();
        this.selectedNode = null;
        for (Entry entry : this.entries.values()) {
            if (entry.node != node) continue;
            entry.setSelected(false);
        }
    }

    @Override
    public void layoutSubviews() {
        super.layoutSubviews();
        if (this.dirt) {
            this.buildEntriesIfNeeded();
            this.dirt = false;
        }
    }

    @Override
    public void menuControllerDidShow(UIMenuController menuController) {
        this.currentMenuController = menuController;
    }

    @Override
    public void menuControllerDidDismiss(UIMenuController menuController) {
        this.currentMenuController = null;
    }

    public void setNeedsDisplay(TreeNode node) {
        this.dirt = true;
        this.setNeedsLayout();
    }

    public UIMenuController menuController() {
        if (this.menuController != null) {
            return this.menuController;
        }
        return UIMenuController.getInstance();
    }

    public void setMenuController(UIMenuController menuController) {
        this.menuController = menuController;
    }

    @Override
    public TreeViewDelegate delegate() {
        return this.delegate.get();
    }

    public void setDelegate(TreeViewDelegate delegate) {
        super.setDelegate(delegate);
        this.delegate.set(delegate);
    }

    private void buildEntriesIfNeeded() {
        CGRect bounds = this.bounds();
        CGSize itemSize = new CGSize(bounds.width, 11.0f);
        CGSize contentSize = new CGSize(0.0f, 0.0f);
        HashMap<String, Entry> removedEntries = new HashMap<String, Entry>(this.entries);
        this.buildEntry("", 0.0f, 0.0f, itemSize, contentSize, this.rootNode, removedEntries);
        this.setContentSize(contentSize);
        removedEntries.forEach((key, view) -> {
            view.removeFromSuperview();
            this.entries.remove(key);
        });
    }

    private void buildEntry(String key, float x, float y, CGSize itemSize, CGSize contentSize, TreeNode node, HashMap<String, Entry> removedEntries) {
        if (!key.isEmpty()) {
            CGRect rect = new CGRect(0.0f, y, itemSize.width, itemSize.height);
            Entry entry = removedEntries.remove(key);
            if (entry == null) {
                entry = new Entry(rect);
                this.entries.put(key, entry);
                this.addSubview(entry);
            }
            float iconSize = itemSize.height;
            entry.setup(node, rect, x, iconSize);
            entry.setSelected(node == this.selectedNode);
            contentSize.width = itemSize.width;
            contentSize.height = y + itemSize.height;
            x += iconSize;
        }
        if (node.isFolding()) {
            return;
        }
        int index = 0;
        for (TreeNode child : node.children()) {
            String key1 = key + ":" + index++;
            this.buildEntry(key1, x, contentSize.height, itemSize, contentSize, child, removedEntries);
        }
    }

    private void showNodeMenuAtPoint(TreeNode node, CGPoint point) {
        Collection<UIMenuItem> menuItems = this.delegate.invoker().treeViewShouldShowMenuForNode(this, node);
        if (menuItems == null || menuItems.isEmpty()) {
            return;
        }
        UIMenuController menuController = this.menuController();
        menuController.setMenuItems(menuItems);
        menuController.showMenu(this, point);
        menuController.setDelegate(this);
    }

    private void hideNodeMenuIfNeeded() {
        if (this.currentMenuController != null) {
            this.currentMenuController.dismissMenu();
        }
    }

    protected static class Entry
    extends UIControl {
        private static final UIImage FOLDING_IMAGE = UIImage.of(ModTextures.LIST).uv(8.0f, 240.0f).build();
        private static final UIImage UNFOLDING_IMAGE = UIImage.of(ModTextures.LIST).uv(8.0f, 248.0f).build();
        private TreeNode node;
        private NSString cachedTitle;
        private Object title;
        private CGRect iconRect = CGRect.ZERO;
        private final StateValueImpl<UIColor> textColor = new StateValueImpl();
        private final StateValueImpl<UIColor> backgroundColor = new StateValueImpl();

        public Entry(CGRect frame) {
            super(frame);
            this.textColor.setValueForState(AppearanceImpl.TREE_TEXT_COLOR, 0);
            this.textColor.setValueForState(AppearanceImpl.TREE_HIGHLIGHTED_TEXT_COLOR, 1);
            this.textColor.setValueForState(AppearanceImpl.TREE_HIGHLIGHTED_TEXT_COLOR, 3);
            this.textColor.setValueForState(AppearanceImpl.TREE_TEXT_COLOR, 2);
            this.backgroundColor.setValueForState(AppearanceImpl.TREE_HIGHLIGHTED_BACKGROUND_COLOR, 1);
            this.backgroundColor.setValueForState(AppearanceImpl.TREE_SELECTED_BACKGROUND_COLOR, 2);
            this.setHighlighted(false);
        }

        public void setup(TreeNode node, CGRect rect, float offset, float size) {
            this.setFrame(rect);
            if (this.node == node) {
                return;
            }
            this.node = node;
            this.iconRect = new CGRect(offset + 1.0f, 1.0f, 8.0f, 8.0f);
            this.setEnabled(node.isEnabled());
        }

        @Override
        public void render(CGPoint point, CGGraphicsContext context) {
            super.render(point, context);
            if (this.node != null && !this.node.children().isEmpty()) {
                context.setBlendColor(this.textColor.currentValue());
                if (this.node.isFolding()) {
                    context.drawImage(FOLDING_IMAGE, this.iconRect);
                } else {
                    context.drawImage(UNFOLDING_IMAGE, this.iconRect);
                }
                context.setBlendColor(UIColor.WHITE);
            }
            this.updateTitleIfNeeded();
            if (this.cachedTitle != null) {
                context.drawText(this.cachedTitle, this.iconRect.getMaxX(), 1.0f, UIFont.systemFont(), this.textColor.currentValue(), null);
            }
        }

        @Override
        public void mouseDown(UIEvent event) {
            super.mouseDown(event);
            if (this.node == null) {
                return;
            }
            if (!this.node.children().isEmpty() && this.iconRect.contains(event.locationInView(this))) {
                this.node.setFolding(!this.node.isFolding());
                SoundManagerImpl.click();
                return;
            }
            TreeView treeView = ObjectUtils.safeCast(this.superview(), TreeView.class);
            if (treeView != null) {
                treeView.selectNode(this.node);
                SoundManagerImpl.click();
            }
            if (treeView != null && event.type() == UIEvent.Type.MOUSE_RIGHT_DOWN) {
                treeView.showNodeMenuAtPoint(this.node, event.locationInView(treeView));
            }
        }

        @Override
        protected void updateStateIfNeeded() {
            super.updateStateIfNeeded();
            int state = 0;
            if (this.isHighlighted()) {
                state |= 1;
            }
            if (this.isSelected()) {
                state |= 2;
            }
            if (!this.isEnabled()) {
                state |= 4;
            }
            this.textColor.setCurrentState(state);
            this.backgroundColor.setCurrentState(state);
            this.setBackgroundColor(this.backgroundColor.currentValue());
        }

        private void updateTitleIfNeeded() {
            String value;
            if (this.node != null && this.title != (value = this.node.title())) {
                this.title = value;
                this.cachedTitle = new NSString(value);
            }
        }
    }
}

