/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.model;

import java.lang.reflect.Proxy;
import moe.plushie.armourers_workshop.api.data.IAssociatedObjectProvider;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.EmbeddedSkinStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BakedModelStorage {
    private static IBakedModel SHARED_MODEL;
    final ItemStack itemStack;
    final EmbeddedSkinStack embeddedStack;
    final World level;
    final LivingEntity entity;
    final IBakedModel bakedModel;

    public BakedModelStorage(ItemStack itemStack, EmbeddedSkinStack embeddedStack, LivingEntity entity, @Nullable World level, IBakedModel bakedModel) {
        this.itemStack = itemStack;
        this.embeddedStack = embeddedStack;
        this.level = level;
        this.entity = entity;
        this.bakedModel = bakedModel;
    }

    @Nullable
    public static BakedModelStorage unwrap(IBakedModel bakedModel) {
        if (bakedModel instanceof IAssociatedObjectProvider) {
            return (BakedModelStorage)((IAssociatedObjectProvider)bakedModel).getAssociatedObject();
        }
        return null;
    }

    public static IBakedModel wrap(IBakedModel bakedModel, ItemStack itemStack, EmbeddedSkinStack embeddedStack, LivingEntity entity, @Nullable World level) {
        if (level == null) {
            bakedModel = BakedModelStorage.getSkinBakedModel();
        }
        Class[] classes = new Class[]{IBakedModel.class, IAssociatedObjectProvider.class};
        BakedModelStorage storage = new BakedModelStorage(itemStack, embeddedStack, entity, level, bakedModel);
        return (IBakedModel)Proxy.newProxyInstance(IBakedModel.class.getClassLoader(), classes, (proxy, method, methodArgs) -> {
            if (method.getDeclaringClass() == IAssociatedObjectProvider.class) {
                return storage;
            }
            return method.invoke((Object)storage.bakedModel, methodArgs);
        });
    }

    public static IBakedModel getSkinBakedModel() {
        if (SHARED_MODEL == null) {
            SHARED_MODEL = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation(ModConstants.key("skin"), "inventory"));
        }
        return SHARED_MODEL;
    }

    public IBakedModel getOriginModel() {
        return this.bakedModel;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public World getLevel() {
        return this.level;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public EmbeddedSkinStack getEmbeddedStack() {
        return this.embeddedStack;
    }
}

