/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.api.client.IRenderBufferObject;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderObject
implements IRenderBufferObject,
AutoCloseable {
    protected int id = -1;
    protected int size = 0;
    protected final AtomicInteger refCount = new AtomicInteger(1);

    public SkinRenderObject() {
        RenderSystem.glGenBuffers(id -> {
            this.id = id;
        });
    }

    public static void unbind() {
        RenderSystem.glBindBuffer((int)34962, () -> 0);
    }

    @Override
    public void bind() {
        RenderSystem.glBindBuffer((int)34962, () -> this.id);
    }

    public void upload(ByteBuffer byteBuffer) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.upload(byteBuffer));
            return;
        }
        if (this.id < 0) {
            return;
        }
        this.bind();
        this.size = byteBuffer.limit();
        RenderSystem.glBufferData((int)34962, (ByteBuffer)byteBuffer, (int)35044);
        SkinRenderObject.unbind();
    }

    void retain() {
        this.refCount.incrementAndGet();
    }

    void release() {
        int count = this.refCount.decrementAndGet();
        if (count <= 0) {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.id < 0) {
            return;
        }
        int id = this.id;
        Minecraft.func_71410_x().execute(() -> RenderSystem.glDeleteBuffers((int)id));
        this.id = -1;
        this.refCount.set(0);
    }
}

