/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import com.apple.library.uikit.UIColor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IRenderedBuffer;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferBuilder;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.Fix16;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderObject;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.data.cache.SkinCache;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ColorUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.OpenPoseStack;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderObjectBuilder
implements SkinRenderBufferSource.ObjectBuilder {
    private static final ExecutorService workThread = ThreadUtils.newFixedThreadPool(1, "AW-SKIN-VB");
    private static final Cache<Object, CachedTask> cachingTasks = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.SECONDS).removalListener(CachedTask::release).build();
    protected final BakedSkin skin;
    protected final CachedRenderPipeline cachedRenderPipeline = new CachedRenderPipeline();
    protected final ArrayList<CachedTask> pendingCacheTasks = new ArrayList();
    protected boolean isSent = false;

    public SkinRenderObjectBuilder(BakedSkin skin) {
        this.skin = skin;
    }

    public static void clearAllCache() {
        cachingTasks.invalidateAll();
        cachingTasks.cleanUp();
    }

    @Override
    public int addPart(BakedSkinPart part, BakedSkin bakedSkin, ColorScheme scheme, boolean shouldRender, SkinRenderContext context) {
        if (ModDebugger.vertexBufferObject) {
            return this.draw(part, bakedSkin, scheme, context.getOverlay(), context);
        }
        CachedTask cachedTask = this.compile(part, bakedSkin, scheme, context.getOverlay());
        if (cachedTask != null) {
            if (!shouldRender) {
                return 0;
            }
            return this.cachedRenderPipeline.draw(cachedTask, context);
        }
        return 0;
    }

    @Override
    public void addShape(Vector3f origin, SkinRenderContext context) {
        IBufferSource buffers = AbstractBufferSource.defaultBufferSource();
        ShapeTesselator.vector(origin, 16.0f, context.pose(), buffers);
    }

    @Override
    public void addShape(OpenVoxelShape shape, UIColor color, SkinRenderContext context) {
        IBufferSource buffers = AbstractBufferSource.defaultBufferSource();
        ShapeTesselator.stroke(shape.bounds(), color, context.pose(), buffers);
    }

    @Override
    public void addShape(BakedArmature armature, SkinRenderContext context) {
        IBufferSource buffers = AbstractBufferSource.defaultBufferSource();
        IJointTransform[] transforms = armature.getTransforms();
        Armature armature1 = armature.getArmature();
        for (IJoint joint : armature1.allJoints()) {
            JointShape shape = armature1.getShape(joint.getId());
            IJointTransform transform = transforms[joint.getId()];
            if (ModDebugger.defaultArmature) {
                transform = armature1.getGlobalTransform(joint.getId());
            }
            if (shape == null || transform == null) continue;
            context.pushPose();
            transform.apply(context.pose());
            ShapeTesselator.stroke(shape, ColorUtils.getPaletteColor(joint.getId()), context.pose(), buffers);
            ShapeTesselator.vector(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f, context.pose(), buffers);
            context.popPose();
        }
    }

    public void endBatch(SkinVertexBufferBuilder.Pipeline pipeline) {
        this.cachedRenderPipeline.commit(pipeline::add);
    }

    @Nullable
    public CachedTask compile(BakedSkinPart part, BakedSkin bakedSkin, ColorScheme scheme, int overlay) {
        Object key = SkinCache.borrowKey(bakedSkin.getId(), part.getId(), part.requirements(scheme), overlay);
        CachedTask cachedTask = (CachedTask)cachingTasks.getIfPresent(key);
        if (cachedTask != null) {
            SkinCache.returnKey(key);
            if (cachedTask.isCompiled) {
                return cachedTask;
            }
            return null;
        }
        cachedTask = new CachedTask(part, scheme, overlay);
        cachingTasks.put(key, (Object)cachedTask);
        this.addCompileTask(cachedTask);
        return null;
    }

    private synchronized void addCompileTask(CachedTask cachedTask) {
        this.pendingCacheTasks.add(cachedTask);
        if (this.isSent) {
            return;
        }
        this.isSent = true;
        workThread.execute(this::doCompile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompile() {
        ArrayList<CachedTask> tasks;
        SkinRenderObjectBuilder skinRenderObjectBuilder = this;
        synchronized (skinRenderObjectBuilder) {
            tasks = new ArrayList<CachedTask>(this.pendingCacheTasks);
            this.pendingCacheTasks.clear();
            this.isSent = false;
        }
        if (tasks.isEmpty()) {
            return;
        }
        OpenPoseStack poseStack1 = new OpenPoseStack();
        ArrayList<CompiledTask> buildingTasks = new ArrayList<CompiledTask>();
        for (CachedTask task : tasks) {
            int overlay = task.overlay;
            BakedSkinPart part = task.part;
            ColorScheme scheme = task.scheme;
            ArrayList mergedTasks = new ArrayList();
            part.forEach((renderType, quads) -> {
                AbstractBufferBuilder builder = new AbstractBufferBuilder(quads.size() * 8 * renderType.func_228663_p_().func_177338_f());
                builder.begin((RenderType)renderType);
                quads.forEach(quad -> quad.render(part, scheme, 0xF000F0, overlay, poseStack1, builder));
                IRenderedBuffer renderedBuffer = builder.end();
                CompiledTask compiledTask = new CompiledTask((RenderType)renderType, renderedBuffer, part.getRenderPolygonOffset(), part.getType());
                mergedTasks.add(compiledTask);
                buildingTasks.add(compiledTask);
            });
            task.mergedTasks = mergedTasks;
        }
        this.combineAndUpload(tasks, buildingTasks);
    }

    private int draw(BakedSkinPart part, BakedSkin bakedSkin, ColorScheme scheme, int overlay, SkinRenderContext context) {
        IBufferSource buffers = context.getBuffers();
        IPoseStack poseStack1 = context.pose();
        part.forEach((renderType, quads) -> quads.forEach(quad -> quad.render(part, scheme, 0xF000F0, overlay, poseStack1, buffers.getBuffer((RenderType)renderType))));
        return 1;
    }

    private void combineAndUpload(ArrayList<CachedTask> qt, ArrayList<CompiledTask> buildingTasks) {
        int totalRenderedBytes = 0;
        SkinRenderObject vertexBuffer = new SkinRenderObject();
        ArrayList<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>();
        for (CompiledTask compiledTask : buildingTasks) {
            BufferBuilder.DrawState drawState = compiledTask.bufferBuilder.drawState();
            VertexFormat format = drawState.func_227838_a_();
            ByteBuffer byteBuffer = compiledTask.bufferBuilder.vertexBuffer();
            compiledTask.vertexBuffer = vertexBuffer;
            compiledTask.vertexCount = drawState.func_227839_b_();
            compiledTask.vertexOffset = totalRenderedBytes;
            compiledTask.bufferBuilder.release();
            compiledTask.bufferBuilder = null;
            compiledTask.format = format;
            byteBuffers.add(byteBuffer);
            totalRenderedBytes += byteBuffer.remaining();
        }
        ByteBuffer mergedByteBuffer = ByteBuffer.allocateDirect(totalRenderedBytes);
        for (ByteBuffer byteBuffer : byteBuffers) {
            mergedByteBuffer.put(byteBuffer);
        }
        mergedByteBuffer.rewind();
        vertexBuffer.upload(mergedByteBuffer);
        RenderSystem.recordRenderCall(() -> {
            for (CachedTask cachedTask : qt) {
                cachedTask.setRenderObject(vertexBuffer);
                cachedTask.finish();
            }
            vertexBuffer.release();
        });
    }

    static class CachedRenderPipeline {
        protected final ArrayList<CompiledPass> tasks = new ArrayList();

        CachedRenderPipeline() {
        }

        int draw(CachedTask task, SkinRenderContext context) {
            int lightmap = context.getLightmap();
            float animationTicks = context.getAnimationTicks();
            float renderPriority = context.getReferenced().getRenderPriority();
            IPoseStack poseStack = context.pose();
            IPoseStack modelViewStack = AbstractPoseStack.wrap(Fix16.getModelViewStack(RenderSystem.class));
            OpenPoseStack finalPostStack = new OpenPoseStack();
            OpenMatrix4f lastPose = finalPostStack.last().pose();
            OpenMatrix3f lastNormal = finalPostStack.last().normal();
            lastPose.multiply(modelViewStack.last().pose());
            lastPose.multiply(poseStack.last().pose());
            lastNormal.multiply(poseStack.last().normal());
            lastNormal.invert();
            task.mergedTasks.forEach(t -> this.tasks.add(new CompiledPass((CompiledTask)t, finalPostStack, lightmap, animationTicks, renderPriority)));
            return task.totalTask;
        }

        void commit(Consumer<ShaderVertexObject> consumer) {
            if (this.tasks.size() != 0) {
                this.tasks.forEach((Consumer<CompiledPass>)consumer);
                this.tasks.clear();
            }
        }
    }

    static class CachedTask {
        int totalTask;
        boolean isCompiled = false;
        ArrayList<CompiledTask> mergedTasks;
        BakedSkinPart part;
        ColorScheme scheme;
        int overlay;
        SkinRenderObject renderObject;

        CachedTask(BakedSkinPart part, ColorScheme scheme, int overlay) {
            this.part = part;
            this.scheme = scheme.copy();
            this.overlay = overlay;
        }

        static void release(RemovalNotification<Object, Object> notification) {
            CachedTask task = ObjectUtils.safeCast(notification.getValue(), CachedTask.class);
            if (task != null) {
                task.setRenderObject(null);
            }
        }

        void setRenderObject(SkinRenderObject renderObject) {
            if (this.renderObject != null) {
                this.renderObject.release();
            }
            this.renderObject = renderObject;
            if (this.renderObject != null) {
                this.renderObject.retain();
            }
        }

        void finish() {
            this.isCompiled = true;
            this.totalTask = this.mergedTasks.size();
        }
    }

    static class CompiledTask {
        final float polygonOffset;
        final ISkinPartType partType;
        final RenderType renderType;
        int vertexCount;
        int vertexOffset;
        IRenderedBuffer bufferBuilder;
        SkinRenderObject vertexBuffer;
        VertexFormat format;

        CompiledTask(RenderType renderType, IRenderedBuffer bufferBuilder, float polygonOffset, ISkinPartType partType) {
            this.partType = partType;
            this.renderType = renderType;
            this.bufferBuilder = bufferBuilder;
            this.polygonOffset = polygonOffset;
        }
    }

    static class CompiledPass
    extends ShaderVertexObject {
        int lightmap;
        float animationTicks;
        float additionalPolygonOffset;
        boolean isGrowing;
        OpenPoseStack poseStack;
        CompiledTask compiledTask;

        CompiledPass(CompiledTask compiledTask, OpenPoseStack poseStack, int lightmap, float animationTicks, float renderPriority) {
            this.compiledTask = compiledTask;
            this.poseStack = poseStack;
            this.lightmap = lightmap;
            this.animationTicks = animationTicks;
            this.isGrowing = SkinRenderType.isGrowing(compiledTask.renderType);
            this.additionalPolygonOffset = renderPriority;
        }

        @Override
        public RenderType getType() {
            return this.compiledTask.renderType;
        }

        @Override
        public int getVertexOffset() {
            return this.compiledTask.vertexOffset;
        }

        @Override
        public int getVertexCount() {
            return this.compiledTask.vertexCount;
        }

        @Override
        public SkinRenderObject getVertexBuffer() {
            return this.compiledTask.vertexBuffer;
        }

        @Override
        public float getPolygonOffset() {
            return this.compiledTask.polygonOffset + this.additionalPolygonOffset;
        }

        @Override
        public OpenPoseStack getPoseStack() {
            return this.poseStack;
        }

        @Override
        public VertexFormat getFormat() {
            if (this.compiledTask.format == null) {
                return this.compiledTask.renderType.func_228663_p_();
            }
            return this.compiledTask.format;
        }

        @Override
        public int getLightmap() {
            return this.lightmap;
        }

        @Override
        public boolean isGrowing() {
            return this.isGrowing;
        }
    }
}

