/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.data.ticket.Ticket;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderTesselator
extends SkinRenderContext {
    private final BakedSkin bakedSkin;
    private final BakedArmature bakedArmature;
    private final MannequinEntity mannequin;

    public SkinRenderTesselator(BakedSkin bakedSkin, BakedArmature bakedArmature, MannequinEntity mannequin) {
        super(null);
        this.bakedSkin = bakedSkin;
        this.mannequin = mannequin;
        this.bakedArmature = bakedArmature;
    }

    public static SkinRenderTesselator create(SkinDescriptor descriptor, Ticket ticket) {
        BakedSkin bakedSkin = SkinBakery.getInstance().loadSkin(descriptor, ticket);
        if (bakedSkin != null) {
            return SkinRenderTesselator.create(bakedSkin);
        }
        return null;
    }

    public static SkinRenderTesselator create(BakedSkin bakedSkin) {
        MannequinEntity mannequin = PlaceholderManager.MANNEQUIN.get();
        BakedArmature bakedArmature = BakedArmature.defaultBy(bakedSkin.getType());
        if (bakedArmature == null || mannequin == null || PropertyProvider.getLevel((Entity)mannequin) == null) {
            return null;
        }
        return new SkinRenderTesselator(bakedSkin, bakedArmature, mannequin);
    }

    public int draw(IPoseStack poseStack, IBufferSource bufferSource) {
        this.setPose(poseStack);
        this.setBuffers(bufferSource);
        this.bakedSkin.setupAnim((Entity)this.mannequin, this.getAnimationTicks(), this.getReferenced());
        return SkinRenderer.render((Entity)this.mannequin, this.bakedArmature, this.bakedSkin, this.getColorScheme(), this);
    }

    public MannequinEntity getMannequin() {
        return this.mannequin;
    }

    public BakedSkin getBakedSkin() {
        return this.bakedSkin;
    }

    public Rectangle3f getBakedRenderBounds() {
        return this.bakedSkin.getRenderBounds(this.getReferenced());
    }
}

