/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.api.common.ITextureProperties;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import moe.plushie.armourers_workshop.utils.texture.TextureAnimation;
import moe.plushie.armourers_workshop.utils.texture.TextureAnimationController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinTextureManager {
    private static final SkinTextureManager INSTANCE = new SkinTextureManager();
    private final AtomicInteger counter = new AtomicInteger(0);
    private final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private final ConcurrentHashMap<ITextureProvider, ResourceLocation> textures = new ConcurrentHashMap();
    private final ConcurrentHashMap<ITextureProvider, RenderType> renderTypes = new ConcurrentHashMap();
    private final ConcurrentHashMap<ITextureProvider, Collection<RenderType>> renderTypeVariants = new ConcurrentHashMap();
    private final ConcurrentHashMap<RenderType, TextureAnimationController> textureAnimationControllers = new ConcurrentHashMap();

    public static SkinTextureManager getInstance() {
        return INSTANCE;
    }

    public RenderType prepareTexture(ITextureProvider provider) {
        return this.renderTypes.computeIfAbsent(provider, it -> this.registerAnimation(SkinRenderType.solidFace(this.registerTexture((ITextureProvider)it)), (ITextureProvider)it));
    }

    public Collection<RenderType> prepareVariantTextures(ITextureProvider provider) {
        return this.renderTypeVariants.computeIfAbsent(provider, it -> {
            Collection<ITextureProvider> varinats = it.getVariants();
            if (varinats != null) {
                return ObjectUtils.map(varinats, varinat -> this.registerAnimation(SkinRenderType.lightingFace(this.registerTexture((ITextureProvider)varinat, (ITextureProvider)it)), (ITextureProvider)varinat));
            }
            return null;
        });
    }

    public TextureAnimationController getTextureAnimationController(RenderType renderType) {
        if (this.isDefault(renderType)) {
            return TextureAnimationController.DEFAULT;
        }
        return this.textureAnimationControllers.getOrDefault(renderType, TextureAnimationController.NONE);
    }

    public void start() {
    }

    public void stop() {
        this.textures.values().forEach(arg_0 -> ((TextureManager)this.textureManager).func_147645_c(arg_0));
        this.textures.clear();
        this.renderTypes.clear();
        this.renderTypeVariants.clear();
        this.textureAnimationControllers.clear();
        this.counter.set(0);
    }

    private ResourceLocation registerTexture(ITextureProvider provider) {
        return this.textures.computeIfAbsent(provider, k -> {
            ResourceLocation rl = ModConstants.key("textures/dymanic/" + this.counter.getAndIncrement());
            return this.registerTexture(rl, provider);
        });
    }

    private ResourceLocation registerTexture(ITextureProvider variant, ITextureProvider parent) {
        return this.textures.computeIfAbsent(variant, k -> {
            ResourceLocation rl = this.registerTexture(parent);
            rl = new ResourceLocation(rl.func_110624_b(), rl.func_110623_a() + "_" + this.getTextureType(variant));
            return this.registerTexture(rl, variant);
        });
    }

    private ResourceLocation registerTexture(ResourceLocation rl, ITextureProvider provider) {
        ModLog.debug("Registering Dynamic Texture '{}', {}", rl, provider);
        RenderSystem.recordRenderCall(() -> this.textureManager.func_229263_a_(rl, (Texture)new CustomTexture(provider)));
        return rl;
    }

    private RenderType registerAnimation(RenderType renderType, ITextureProvider textureProvider) {
        TextureAnimationController animation = new TextureAnimationController((TextureAnimation)textureProvider.getAnimation());
        this.textureAnimationControllers.put(renderType, animation);
        return renderType;
    }

    private String getTextureType(ITextureProvider provider) {
        ITextureProperties properties = provider.getProperties();
        if (properties.isEmissive()) {
            return "s";
        }
        return String.format("%04x", properties.hashCode());
    }

    private boolean isDefault(RenderType renderType) {
        return renderType == SkinRenderType.FACE_SOLID || renderType == SkinRenderType.FACE_LIGHTING || renderType == SkinRenderType.FACE_TRANSLUCENT || renderType == SkinRenderType.FACE_LIGHTING_TRANSLUCENT;
    }

    public static class CustomTexture
    extends Texture {
        private final ITextureProvider provider;

        CustomTexture(ITextureProvider provider) {
            this.provider = provider;
        }

        public void func_195413_a(IResourceManager resourceManager) throws IOException {
            NativeImage pixels = NativeImage.func_195704_a((ByteBuffer)this.provider.getBuffer());
            TextureUtil.func_225680_a_((int)this.func_110552_b(), (int)pixels.func_195702_a(), (int)pixels.func_195714_b());
            pixels.func_195697_a(0, 0, 0, false);
            pixels.close();
        }
    }
}

