/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.HashMap;
import moe.plushie.armourers_workshop.api.client.IBufferBuilder;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IRenderAttachable;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.compatibility.AbstractShader;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferBuilder;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderObjectBuilder;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexMerger;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkinVertexBufferBuilder
implements IBufferSource {
    private static SkinVertexBufferBuilder MERGED_VERTEX_BUILDER;
    protected final Pipeline pipeline = new Pipeline();
    protected final HashMap<BakedSkin, SkinRenderObjectBuilder> cachingBuilders = new HashMap();
    protected final HashMap<RenderType, AbstractBufferBuilder> cachingBuilders2 = new HashMap();
    protected final HashMap<BakedSkin, SkinRenderObjectBuilder> pendingBuilders = new HashMap();
    protected final HashMap<RenderType, AbstractBufferBuilder> pendingBuilders2 = new HashMap();

    public static SkinVertexBufferBuilder getBuffer(IBufferSource bufferSource) {
        SkinVertexBufferBuilder.attach(bufferSource, Atlases.func_228782_g_(), SkinVertexBufferBuilder::renderSolid);
        return SkinVertexBufferBuilder.getInstance();
    }

    private static void attach(IBufferSource bufferSource, RenderType renderType, Runnable action) {
        IVertexConsumer buffer = bufferSource.getBuffer(renderType);
        IRenderAttachable attachable = ObjectUtils.safeCast(renderType, IRenderAttachable.class);
        if (attachable != null) {
            attachable.attachRenderTask(buffer, action);
        }
    }

    public static void renderSolid() {
        SkinVertexBufferBuilder.getInstance().endBatch();
    }

    public static void renderTranslucent() {
        SkinVertexBufferBuilder.getInstance().endBatch();
    }

    public static SkinVertexBufferBuilder getInstance() {
        if (MERGED_VERTEX_BUILDER == null) {
            MERGED_VERTEX_BUILDER = new SkinVertexBufferBuilder();
        }
        return MERGED_VERTEX_BUILDER;
    }

    public static void clearAllCache() {
        SkinVertexBufferBuilder builder = SkinVertexBufferBuilder.getInstance();
        builder.cachingBuilders.clear();
        builder.cachingBuilders2.clear();
        builder.pipeline.clear();
        SkinRenderObjectBuilder.clearAllCache();
    }

    @Override
    @NotNull
    public IBufferBuilder getBuffer(@NotNull RenderType renderType) {
        AbstractBufferBuilder buffer = this.pendingBuilders2.get(renderType);
        if (buffer != null) {
            return buffer;
        }
        buffer = this.cachingBuilders2.computeIfAbsent(renderType, k -> new AbstractBufferBuilder(k.func_228662_o_()));
        buffer.begin(renderType);
        this.pendingBuilders2.put(renderType, buffer);
        return buffer;
    }

    public SkinRenderObjectBuilder getBuffer(@NotNull BakedSkin skin) {
        SkinRenderObjectBuilder bufferBuilder = this.pendingBuilders.get(skin);
        if (bufferBuilder != null) {
            return bufferBuilder;
        }
        bufferBuilder = this.cachingBuilders.computeIfAbsent(skin, SkinRenderObjectBuilder::new);
        this.pendingBuilders.put(skin, bufferBuilder);
        return bufferBuilder;
    }

    @Override
    public void endBatch() {
        if (!this.pendingBuilders.isEmpty()) {
            for (SkinRenderObjectBuilder builder : this.pendingBuilders.values()) {
                builder.endBatch(this.pipeline);
            }
            this.pendingBuilders.clear();
            this.pipeline.end();
        }
        if (!this.pendingBuilders2.isEmpty()) {
            this.pendingBuilders2.forEach(AbstractBufferBuilder::upload);
            this.pendingBuilders2.clear();
        }
    }

    public static class Pipeline {
        private final AbstractShader shader = new AbstractShader();
        private final ShaderVertexMerger merger = new ShaderVertexMerger();

        public void add(ShaderVertexObject pass) {
            this.merger.add(pass);
        }

        public void end() {
            if (this.merger.isEmpty()) {
                return;
            }
            this.merger.prepare();
            this.shader.begin();
            this.merger.forEach(group -> this.shader.apply((ShaderVertexGroup)group, () -> group.forEach(this.shader::render)));
            this.shader.end();
            this.merger.reset();
        }

        public void clear() {
            this.merger.clear();
        }
    }
}

