/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.data.IAssociatedObjectProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import net.minecraft.client.renderer.entity.EntityRenderer;

public class EntityRendererStorage {
    private final EntityRenderer<?> entityRenderer;
    private final HashMap<Object, BakedArmatureTransformer> transformers = new HashMap();

    public EntityRendererStorage(EntityRenderer<?> entityRenderer) {
        this.entityRenderer = entityRenderer;
    }

    public static EntityRendererStorage of(EntityRenderer<?> entityRenderer) {
        return IAssociatedObjectProvider.of(entityRenderer, EntityRendererStorage::new);
    }

    public <T> BakedArmatureTransformer getTransformer(T key) {
        return this.transformers.get(key);
    }

    public <T> BakedArmatureTransformer computeTransformerIfAbsent(T key, Function<T, BakedArmatureTransformer> factory) {
        return this.transformers.computeIfAbsent(key, it -> (BakedArmatureTransformer)factory.apply(key));
    }
}

