/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.data.MannequinHitResult;
import moe.plushie.armourers_workshop.core.data.SkinBlockPlaceContext;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HighlightPlacementRenderer {
    public static void renderBlock(ItemStack itemStack, PlayerEntity player, BlockRayTraceResult traceResult, ActiveRenderInfo renderInfo, IPoseStack poseStack, IBufferSource bufferSource) {
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (descriptor.getType() != SkinTypes.BLOCK) {
            return;
        }
        poseStack.pushPose();
        float f = 0.0625f;
        Vector3f origin = new Vector3f((IPosition)renderInfo.func_216785_c());
        SkinBlockPlaceContext context = new SkinBlockPlaceContext(player, Hand.MAIN_HAND, itemStack, traceResult);
        BlockPos location = context.func_195995_a();
        poseStack.translate((float)location.func_177958_n() - origin.getX(), (float)location.func_177956_o() - origin.getY(), (float)location.func_177952_p() - origin.getZ());
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.scale(f, f, f);
        for (SkinBlockPlaceContext.Part part : context.getParts()) {
            BlockPos pos = part.getOffset();
            UIColor color = UIColor.RED;
            if (context.canPlace(part)) {
                color = UIColor.WHITE;
            }
            poseStack.pushPose();
            poseStack.translate((float)pos.func_177958_n() * 16.0f, (float)pos.func_177956_o() * 16.0f, (float)pos.func_177952_p() * 16.0f);
            ShapeTesselator.stroke(part.getShape(), color, poseStack, bufferSource);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public static void renderEntity(PlayerEntity player, BlockRayTraceResult traceResult, ActiveRenderInfo renderInfo, IPoseStack poseStack, IBufferSource bufferSource) {
        Vector3f origin = new Vector3f((IPosition)renderInfo.func_216785_c());
        MannequinHitResult target = MannequinHitResult.test(player, origin, traceResult.func_216347_e(), traceResult.func_216350_a());
        poseStack.pushPose();
        Vector3f location = new Vector3f((IPosition)target.func_216347_e());
        poseStack.translate(location.getX() - origin.getX(), location.getY() - origin.getY(), location.getZ() - origin.getZ());
        poseStack.rotate(Vector3f.YP.rotationDegrees(-target.getRotation()));
        MannequinModel<?> model = SkinItemRenderer.getInstance().getMannequinModel();
        if (model != null) {
            float f = target.getScale() * 0.9375f;
            IRenderTypeBuffer buffers1 = AbstractBufferSource.unwrap(bufferSource);
            IVertexBuilder builder = buffers1.getBuffer(SkinRenderType.HIGHLIGHTED_ENTITY_LINES);
            poseStack.pushPose();
            poseStack.scale(f, f, f);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            poseStack.translate(0.0f, -1.501f, 0.0f);
            model.func_225598_a_(AbstractPoseStack.unwrap(poseStack), builder, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

