/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.render;

import com.apple.library.uikit.UIColor;
import com.mojang.blaze3d.matrix.MatrixStack;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererLayerProvider;
import moe.plushie.armourers_workshop.compatibility.client.AbstractEntityRendererProviderImpl;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractLivingEntityRenderer;
import moe.plushie.armourers_workshop.core.client.model.MannequinArmorModel;
import moe.plushie.armourers_workshop.core.client.model.MannequinModel;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.texture.BakedEntityTexture;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureLoader;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MannequinEntityRenderer<T extends MannequinEntity>
extends AbstractLivingEntityRenderer<T, MannequinModel<T>> {
    public static boolean enableLimitScale = false;
    public static boolean enableLimitYRot = false;
    private final AbstractEntityRendererProviderImpl.Context context;
    private final MannequinModel<T> normalModel;
    private final MannequinModel<T> slimModel;
    private final LayerRenderer<T, MannequinModel<T>> normalArmorLayer;
    private final LayerRenderer<T, MannequinModel<T>> slimArmorLayer;
    private MannequinEntityRenderer<T> mannequinRenderer;
    private ResourceLocation texture;
    private BakedEntityTexture bakedTexture;
    private boolean modelState = false;
    private boolean enableChildRenderer = false;

    public MannequinEntityRenderer(AbstractEntityRendererProviderImpl.Context context) {
        super(context, MannequinModel.normal(context), 0.0f);
        AbstractEntityRendererLayerProvider provider = this.getLayerProvider();
        this.context = context;
        this.normalModel = (MannequinModel)super.func_217764_d();
        this.slimModel = MannequinModel.slim(context);
        this.normalArmorLayer = provider.createHumanoidArmorLayer(context, MannequinArmorModel.normalInner(context), MannequinArmorModel.normalOuter(context));
        this.slimArmorLayer = provider.createHumanoidArmorLayer(context, MannequinArmorModel.slimInner(context), MannequinArmorModel.slimOuter(context));
        this.func_177094_a(this.normalArmorLayer);
        this.func_177094_a(provider.createItemInHandLayer(context));
        this.func_177094_a(provider.createElytraLayer(context));
        this.func_177094_a(provider.createCustomHeadLayer(context));
    }

    public boolean shouldShowName(T entity) {
        return entity.func_145818_k_();
    }

    @Override
    public void render(T entity, float f, float partialTicks, IPoseStack poseStack, IBufferSource bufferSource, int packedLightIn) {
        if (this.enableChildRenderer) {
            this.getChildRenderer().render(entity, f, partialTicks, poseStack, bufferSource, packedLightIn);
            return;
        }
        PlayerTextureLoader textureLoader = PlayerTextureLoader.getInstance();
        this.texture = textureLoader.getTextureLocation((Entity)entity);
        this.bakedTexture = textureLoader.getTextureModel(this.texture);
        this.applyTextureModel(this.bakedTexture);
        ((MannequinModel)super.func_217764_d()).func_178719_a(((MannequinEntity)entity).isModelVisible());
        this.enableChildRenderer = true;
        super.render(entity, f, partialTicks, poseStack, bufferSource, packedLightIn);
        this.enableChildRenderer = false;
        if (ModDebugger.mannequinCulling) {
            poseStack.pushPose();
            AxisAlignedBB box = ((MannequinEntity)entity).func_184177_bl();
            double tx = -box.field_72340_a - (box.field_72336_d - box.field_72340_a) / 2.0;
            double ty = -box.field_72338_b;
            double tz = -box.field_72339_c - (box.field_72334_f - box.field_72339_c) / 2.0;
            poseStack.translate((float)tx, (float)ty, (float)tz);
            ShapeTesselator.stroke(box, UIColor.YELLOW, poseStack, bufferSource);
            poseStack.popPose();
        }
    }

    public void scale(T entity, MatrixStack poseStack, float p_225620_3_) {
        float f = 0.9375f;
        if (!enableLimitScale) {
            f *= ((MannequinEntity)entity).func_213355_cm();
        }
        poseStack.func_227862_a_(f, f, f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.texture;
    }

    public MannequinEntityRenderer<T> getChildRenderer() {
        if (this.mannequinRenderer == null) {
            this.mannequinRenderer = new MannequinEntityRenderer<T>(this.context);
        }
        return this.mannequinRenderer;
    }

    private void applyTextureModel(BakedEntityTexture texture) {
        boolean newModelState;
        boolean bl = newModelState = texture != null && texture.isSlimModel();
        if (this.modelState == newModelState) {
            return;
        }
        this.modelState = newModelState;
        if (this.modelState) {
            this.setModel(this.slimModel);
            this.replaceLayer(this.slimArmorLayer, this.normalArmorLayer);
        } else {
            this.setModel(this.normalModel);
            this.replaceLayer(this.normalArmorLayer, this.slimArmorLayer);
        }
    }

    private void replaceLayer(LayerRenderer<T, MannequinModel<T>> toLayer, LayerRenderer<T, MannequinModel<T>> fromLayer) {
        int index = this.field_177097_h.indexOf(fromLayer);
        if (index >= 0) {
            LayerRenderer<T, MannequinModel<T>> layerRenderer = this.field_177097_h.set(index, toLayer);
        }
    }
}

