/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.core.client.other.SkinTextureManager;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.texture.TextureAnimationController;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShaderVertexGroup {
    public int maxVertexCount;
    private final RenderType renderType;
    private final TextureAnimationController animationController;
    private final ArrayList<ShaderVertexObject> objects = new ArrayList();

    public ShaderVertexGroup(RenderType renderType) {
        this.renderType = renderType;
        this.animationController = SkinTextureManager.getInstance().getTextureAnimationController(renderType);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public OpenMatrix4f getTextureMatrix(int ticks) {
        return this.animationController.getTextureMatrix(ticks);
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public void add(ShaderVertexObject object) {
        this.objects.add(object);
    }

    public void clear() {
        this.objects.clear();
        this.maxVertexCount = 0;
    }

    public void forEach(Consumer<ShaderVertexObject> consumer) {
        this.objects.forEach(consumer);
    }
}

