/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender;

import java.util.HashMap;
import moe.plushie.armourers_workshop.api.common.IEntityTypeProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.layer.SkinWardrobeLayer;
import moe.plushie.armourers_workshop.core.entity.EntityProfile;
import moe.plushie.armourers_workshop.init.ModEntityProfiles;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinRendererManager {
    private static int VERSION = 0;
    private static boolean IS_READY = false;
    private static final HashMap<EntityType<?>, BakedArmatureTransformer> FALLBACK_TRANSFORMERS = new HashMap();
    private static final HashMap<IEntityTypeProvider<?>, EntityProfile> ENTITIES = new HashMap();

    public static void init() {
        ModEntityProfiles.addListener(SkinRendererManager::unbind, SkinRendererManager::bind);
        SkinRendererManager.reload();
    }

    public static void reload() {
        EntityRendererManager entityRenderManager = Minecraft.func_71410_x().func_175598_ae();
        if (entityRenderManager == null) {
            RenderSystem.recordRenderCall(SkinRendererManager::reload);
            return;
        }
        RenderSystem.recordRenderCall(() -> SkinRendererManager._reload(entityRenderManager));
    }

    private static void _reload(EntityRendererManager entityRenderManager) {
        for (EntityRenderer renderer : entityRenderManager.field_178636_l.values()) {
            if (!(renderer instanceof LivingRenderer)) continue;
            SkinRendererManager.setupRenderer(EntityType.field_200729_aH, (LivingRenderer)renderer, true);
        }
        entityRenderManager.field_78729_o.forEach((entityType1, entityRenderer) -> {
            if (entityRenderer instanceof LivingRenderer) {
                SkinRendererManager.setupRenderer(entityType1, (LivingRenderer)entityRenderer, true);
            }
        });
        IS_READY = false;
        FALLBACK_TRANSFORMERS.clear();
        ENTITIES.forEach(SkinRendererManager::_bind);
        ++VERSION;
        IS_READY = true;
    }

    public static void unbind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        ModLog.debug("Detach Entity Renderer '{}'", entityType.getRegistryName());
        ENTITIES.remove(entityType);
        if (IS_READY) {
            // empty if block
        }
    }

    public static void bind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        ModLog.debug("Attach Entity Renderer '{}'", entityType.getRegistryName());
        ENTITIES.put(entityType, entityProfile);
        if (IS_READY) {
            SkinRendererManager._bind(entityType, entityProfile);
        }
    }

    private static void _bind(IEntityTypeProvider<?> entityType, EntityProfile entityProfile) {
        EntityType resolvedEntityType = (EntityType)entityType.get();
        if (resolvedEntityType == null) {
            return;
        }
        EntityRendererManager entityRenderManager = Minecraft.func_71410_x().func_175598_ae();
        if (entityRenderManager == null) {
            return;
        }
        if (resolvedEntityType == EntityType.field_200729_aH) {
            for (EntityRenderer renderer2 : entityRenderManager.field_178636_l.values()) {
                if (!(renderer2 instanceof LivingRenderer)) continue;
                SkinRendererManager.setupRenderer(resolvedEntityType, (LivingRenderer)renderer2, false);
            }
        }
        entityRenderManager.field_78729_o.forEach((entityType1, renderer) -> {
            if (resolvedEntityType.equals(entityType1)) {
                if (renderer instanceof LivingRenderer) {
                    SkinRendererManager.setupRenderer(resolvedEntityType, (LivingRenderer)renderer, false);
                } else {
                    SkinRendererManager.setupFallbackRenderer(resolvedEntityType, renderer);
                }
            }
        });
    }

    private static <T extends LivingEntity, V extends EntityModel<T>> void setupRenderer(EntityType<?> entityType, LivingRenderer<T, V> livingRenderer, boolean autoInject) {
        LayerRenderer armorLayer = null;
        for (LayerRenderer layerRenderer : livingRenderer.field_177097_h) {
            if (layerRenderer instanceof BipedArmorLayer) {
                armorLayer = layerRenderer;
            }
            if (!(layerRenderer instanceof SkinWardrobeLayer)) continue;
            return;
        }
        if (autoInject && armorLayer == null) {
            return;
        }
        BakedArmatureTransformer transformer = BakedArmatureTransformer.defaultBy(entityType, (Model)livingRenderer.func_217764_d(), livingRenderer);
        if (transformer != null) {
            livingRenderer.func_177094_a(new SkinWardrobeLayer(transformer, livingRenderer));
        }
    }

    private static <T extends Entity> void setupFallbackRenderer(EntityType<?> entityType, EntityRenderer<T> renderer) {
        BakedArmatureTransformer transformer = BakedArmatureTransformer.defaultBy(entityType, null, renderer);
        if (transformer != null) {
            FALLBACK_TRANSFORMERS.put(entityType, transformer);
        }
    }

    public static BakedArmatureTransformer getFallbackTransformer(EntityType<?> entityType) {
        return FALLBACK_TRANSFORMERS.get(entityType);
    }

    public static int getVersion() {
        return VERSION;
    }
}

