/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.patch;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformer;
import moe.plushie.armourers_workshop.core.armature.thirdparty.EpicFlightTransformProvider;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmatureTransformer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.core.client.other.thirdparty.EpicFlightModel;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager2;
import moe.plushie.armourers_workshop.core.client.skinrender.patch.EntityRenderPatch;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;

public class EpicFightEntityRendererPatch<T extends LivingEntity>
extends EntityRenderPatch<T> {
    private EntityModel<?> entityModel;
    private final LivingRenderer<?, ?> entityRenderer;
    private IPoseStack overridePoseStack;
    private EpicFlightModel transformerModel;

    public EpicFightEntityRendererPatch(SkinRenderData renderData, LivingRenderer<?, ?> entityRenderer) {
        super(renderData);
        this.entityRenderer = entityRenderer;
    }

    public static <T extends LivingEntity> void activate(T entity, float partialTicks, int packedLight, MatrixStack poseStackIn, IRenderTypeBuffer buffersIn, LivingRenderer<?, ?> entityRenderer, Consumer<EpicFightEntityRendererPatch<T>> handler) {
        EpicFightEntityRendererPatch._activate(EpicFightEntityRendererPatch.class, entity, partialTicks, packedLight, poseStackIn, buffersIn, handler, renderData -> {
            EpicFlightModel model = EpicFlightModel.ofNullable(entityRenderer.func_217764_d());
            if (model != null) {
                return new EpicFightEntityRendererPatch((SkinRenderData)renderData, entityRenderer);
            }
            return null;
        });
    }

    public static <T extends LivingEntity> void apply(T entity, Consumer<EpicFightEntityRendererPatch<T>> handler) {
        EpicFightEntityRendererPatch._apply(EpicFightEntityRendererPatch.class, entity, handler);
    }

    public static <T extends LivingEntity> void deactivate(T entity, Consumer<EpicFightEntityRendererPatch<T>> handler) {
        EpicFightEntityRendererPatch._deactivate(EpicFightEntityRendererPatch.class, entity, handler);
    }

    @Override
    protected void onInit(T entity, float partialTicks, int packedLight, MatrixStack poseStackIn, IRenderTypeBuffer buffersIn) {
        super.onInit(entity, partialTicks, packedLight, poseStackIn, buffersIn);
        EntityModel entityModel = this.entityRenderer.func_217764_d();
        if (this.entityModel != entityModel) {
            this.transformerModel = EpicFlightModel.ofNullable(entityModel);
            this.transformer = this.createTransformer((Entity)entity, this.transformerModel, this.entityRenderer);
            this.entityModel = entityModel;
        }
    }

    public void setFirstPerson(boolean isFirstPerson) {
        if (this.transformer == null) {
            return;
        }
        if (isFirstPerson) {
            this.transformer.setFilter(joint -> !joint.getName().equals("Head") && !joint.getName().equals("Chest") && !joint.getName().equals("Torso"));
        } else {
            this.transformer.setFilter(null);
        }
    }

    public void setMesh(Object mesh) {
        if (this.transformerModel != null) {
            this.transformerModel.linkTo(mesh);
        }
    }

    public void setTransformProvider(EpicFlightTransformProvider transformProvider) {
        if (this.transformerModel != null) {
            this.transformerModel.setAssociatedObject(transformProvider, EpicFlightTransformProvider.KEY);
        }
    }

    public void setOverridePose(IPoseStack pose) {
        this.overridePoseStack = pose;
    }

    public IPoseStack getOverridePose() {
        if (this.overridePoseStack != null) {
            return this.overridePoseStack;
        }
        return this.poseStack;
    }

    private BakedArmatureTransformer createTransformer(Entity entity, EpicFlightModel model, LivingRenderer<?, ?> entityRenderer) {
        ArmatureTransformer transformer;
        if (model != null && (transformer = SkinRendererManager2.EPICFIGHT.getTransformer(entity.func_200600_R(), model)) != null) {
            return BakedArmatureTransformer.create(transformer, entityRenderer);
        }
        return null;
    }
}

