/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.plugin;

import moe.plushie.armourers_workshop.api.client.model.IModelProvider;
import moe.plushie.armourers_workshop.api.data.IAssociatedContainerKey;
import moe.plushie.armourers_workshop.api.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.armature.ArmaturePlugin;
import moe.plushie.armourers_workshop.core.armature.ArmatureTransformerContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderData;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.DataStorageKey;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class MinecartModelArmaturePlugin
extends ArmaturePlugin {
    private static final IAssociatedContainerKey<Boolean> IS_FLAPPED = DataStorageKey.of("isFlapped", Boolean.class, () -> false);

    public MinecartModelArmaturePlugin(ArmatureTransformerContext context) {
        context.addEntityRendererListener(entityRenderer -> {
            IModelProvider modelProvider = (IModelProvider)entityRenderer;
            context.setEntityModel(modelProvider.getModel(null));
        });
    }

    @Override
    public void activate(Entity entity, SkinRenderContext context) {
        AbstractMinecartEntity minecart = (AbstractMinecartEntity)entity;
        IPoseStack poseStack = context.pose();
        if (this.isFlapped(minecart, context.getPartialTicks(), context.getRenderData())) {
            poseStack.rotate(Vector3f.YP.rotationDegrees(180.0f));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(0.0f, -0.125f, 0.0f);
        ModDebugger.translate(poseStack);
        poseStack.rotate(Vector3f.YP.rotationDegrees(180.0f));
    }

    private boolean isFlapped(AbstractMinecartEntity entity, float partialTicks, SkinRenderData renderData) {
        BlockState blockState;
        int k;
        int j;
        int i;
        Vector3d delta = entity.func_213322_ci();
        double dx = delta.func_82615_a();
        double dz = delta.func_82616_c();
        if (dx == 0.0 && dz == 0.0) {
            return renderData.getAssociatedObject(IS_FLAPPED);
        }
        World level = PropertyProvider.getLevel((Entity)entity);
        if (level.func_180495_p(new BlockPos(i = MathUtils.floor(MathUtils.lerp((double)partialTicks, entity.field_70142_S, entity.func_226277_ct_())), (j = MathUtils.floor(MathUtils.lerp((double)partialTicks, entity.field_70137_T, entity.func_226278_cu_()))) - 1, k = MathUtils.floor(MathUtils.lerp((double)partialTicks, entity.field_70136_U, entity.func_226281_cx_())))).func_235714_a_((ITag)BlockTags.field_203437_y)) {
            --j;
        }
        if (!AbstractRailBlock.func_208487_j((BlockState)(blockState = level.func_180495_p(new BlockPos(i, j, k))))) {
            return renderData.getAssociatedObject(IS_FLAPPED);
        }
        RailShape shape = (RailShape)blockState.func_177229_b(((AbstractRailBlock)blockState.func_177230_c()).func_176560_l());
        boolean result = this.isFlapped(shape, dx, dz);
        renderData.setAssociatedObject(result, IS_FLAPPED);
        return result;
    }

    private boolean isFlapped(RailShape shape, double x, double z) {
        double eps = 0.001;
        switch (shape) {
            case NORTH_WEST: 
            case NORTH_EAST: {
                return z < -eps;
            }
            case SOUTH_EAST: 
            case SOUTH_WEST: {
                return z > eps;
            }
            case NORTH_SOUTH: {
                return z < -eps;
            }
            case EAST_WEST: {
                return x < -eps;
            }
            case ASCENDING_EAST: 
            case ASCENDING_WEST: {
                return x < -eps;
            }
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                return z < -eps;
            }
        }
        ModLog.debug("{} - ({}, {})", shape, z, x);
        return false;
    }
}

