/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.ICapabilityType;
import moe.plushie.armourers_workshop.api.common.ITagRepresentable;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class CapabilityStorage {
    private static final ArrayList<Entry<?>> ENTRIES = new ArrayList();
    private static final CapabilityStorage NONE = new CapabilityStorage(new IdentityHashMap());
    private final IdentityHashMap<ICapabilityType<?>, Pair<Entry<?>, Optional<?>>> capabilities;

    CapabilityStorage(IdentityHashMap<ICapabilityType<?>, Pair<Entry<?>, Optional<?>>> capabilities) {
        this.capabilities = capabilities;
    }

    public static <T> void registerCapability(ResourceLocation registryName, ICapabilityType<T> capabilityType, Function<Entity, Optional<T>> provider) {
        ENTRIES.add(new Entry<T>(registryName, capabilityType, provider));
    }

    public static CapabilityStorage attachCapability(Entity entity) {
        if (ENTRIES.isEmpty()) {
            return NONE;
        }
        IdentityHashMap capabilities = new IdentityHashMap();
        for (Entry<?> entry : ENTRIES) {
            Optional cap = entry.provider.apply(entity);
            if (!cap.isPresent()) continue;
            capabilities.put(entry.capabilityType, Pair.of(entry, cap));
        }
        if (capabilities.isEmpty()) {
            return NONE;
        }
        return new CapabilityStorage(capabilities);
    }

    public static <T> Optional<T> getCapability(Entity entity, ICapabilityType<T> capabilityType) {
        CapabilityStorage storage = ((Provider)entity).getCapabilityStorage();
        Pair<Entry<?>, Optional<?>> value = storage.capabilities.get(capabilityType);
        if (value != null) {
            return (Optional)ObjectUtils.unsafeCast((Optional)value.getValue());
        }
        return Optional.empty();
    }

    public void save(Entity entity, CompoundNBT tag) {
        if (this == NONE) {
            return;
        }
        CompoundNBT caps = tag.func_74775_l("ForgeCaps");
        this.capabilities.values().forEach(pair -> {
            ITagRepresentable value1;
            Object tag1;
            Object value = ((Optional)pair.getValue()).orElse(null);
            if (value instanceof ITagRepresentable && (tag1 = (value1 = (ITagRepresentable)ObjectUtils.unsafeCast(value)).serializeNBT()) != null) {
                caps.func_218657_a(((Entry)pair.getKey()).registryName.toString(), tag1);
            }
        });
        if (!caps.isEmpty()) {
            tag.func_218657_a("ForgeCaps", (INBT)caps);
        } else {
            tag.func_82580_o("ForgeCaps");
        }
    }

    public void load(Entity entity, CompoundNBT tag) {
        if (this == NONE) {
            return;
        }
        CompoundNBT caps = this.getCapTag(tag);
        if (caps.isEmpty()) {
            return;
        }
        this.capabilities.values().forEach(pair -> {
            INBT tag1;
            Object value = ((Optional)pair.getValue()).orElse(null);
            if (value instanceof ITagRepresentable && (tag1 = caps.func_74781_a(((Entry)pair.getKey()).registryName.toString())) != null) {
                ITagRepresentable value1 = (ITagRepresentable)ObjectUtils.unsafeCast(value);
                value1.deserializeNBT(tag1);
            }
        });
    }

    private CompoundNBT getCapTag(CompoundNBT tag) {
        if (tag.func_150297_b("ForgeCaps", 10)) {
            CompoundNBT caps = tag.func_74775_l("ForgeCaps");
            if (tag.func_150297_b("neoforge:attachments", 10)) {
                caps = caps.func_74737_b();
                caps.func_197643_a(tag.func_74775_l("neoforge:attachments"));
            }
            return caps;
        }
        return tag.func_74775_l("neoforge:attachments");
    }

    private static class Entry<T> {
        ResourceLocation registryName;
        ICapabilityType<T> capabilityType;
        Function<Entity, Optional<T>> provider;

        Entry(ResourceLocation registryName, ICapabilityType<T> capabilityType, Function<Entity, Optional<T>> provider) {
            this.registryName = registryName;
            this.capabilityType = capabilityType;
            this.provider = provider;
        }
    }

    public static interface Provider {
        public CapabilityStorage getCapabilityStorage();
    }
}

