/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.core.network.ExecuteAlertPacket;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class UserNotifications {
    public static void sendErrorMessage(ITextComponent message, PlayerEntity player) {
        IFormattableTextComponent title = TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.title", new Object[0]);
        IFormattableTextComponent confirm = TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.confirm", new Object[0]);
        UserNotifications.sendToPlayer(new ExecuteAlertPacket((ITextComponent)title, message, (ITextComponent)confirm, 1, null), player);
    }

    public static void sendSystemMessage(ITextComponent message, PlayerEntity player) {
        IFormattableTextComponent title = TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.title", new Object[0]);
        IFormattableTextComponent confirm = TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.confirm", new Object[0]);
        UserNotifications.sendToPlayer(new ExecuteAlertPacket((ITextComponent)title, message, (ITextComponent)confirm, 0, null), player);
    }

    public static void sendSystemToast(ITextComponent message, CompoundNBT tag, PlayerEntity player) {
        IFormattableTextComponent title = TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.title", new Object[0]);
        IFormattableTextComponent confirm = TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.confirm", new Object[0]);
        UserNotifications.sendToPlayer(new ExecuteAlertPacket((ITextComponent)title, message, (ITextComponent)confirm, Integer.MIN_VALUE, tag), player);
    }

    private static void sendToPlayer(ExecuteAlertPacket packet, PlayerEntity player) {
        ServerPlayerEntity serverPlayer = ObjectUtils.safeCast(player, ServerPlayerEntity.class);
        if (serverPlayer != null) {
            NetworkManager.sendToTracking(packet, (Entity)serverPlayer);
        }
    }
}

