/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.transform;

import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.api.math.ITransformf;
import moe.plushie.armourers_workshop.api.math.IVector3f;
import moe.plushie.armourers_workshop.compatibility.api.AbstractItemTransformType;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class SkinItemTransforms
extends LinkedHashMap<String, ITransformf> {
    public SkinItemTransforms() {
    }

    public SkinItemTransforms(CompoundNBT nbt) {
        for (String key : nbt.func_150296_c()) {
            this.put(key, this.deserializeTransform(nbt.func_150295_c(key, 5)));
        }
    }

    @Override
    public void put(AbstractItemTransformType key, ITransformf value) {
        this.put(key.getName(), value);
    }

    public ITransformf get(AbstractItemTransformType key) {
        return (ITransformf)super.get(key.getName());
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        this.forEach((key, value) -> nbt.func_218657_a(key, (INBT)this.serializeTransform((ITransformf)value)));
        return nbt;
    }

    private ListNBT serializeTransform(ITransformf transform) {
        ListNBT tag = new ListNBT();
        if (transform.isIdentity()) {
            return tag;
        }
        IVector3f translate = transform.getTranslate();
        tag.add((Object)FloatNBT.func_229689_a_((float)translate.getX()));
        tag.add((Object)FloatNBT.func_229689_a_((float)translate.getY()));
        tag.add((Object)FloatNBT.func_229689_a_((float)translate.getZ()));
        IVector3f rotation = transform.getRotation();
        tag.add((Object)FloatNBT.func_229689_a_((float)rotation.getX()));
        tag.add((Object)FloatNBT.func_229689_a_((float)rotation.getY()));
        tag.add((Object)FloatNBT.func_229689_a_((float)rotation.getZ()));
        IVector3f scale = transform.getScale();
        tag.add((Object)FloatNBT.func_229689_a_((float)scale.getX()));
        tag.add((Object)FloatNBT.func_229689_a_((float)scale.getY()));
        tag.add((Object)FloatNBT.func_229689_a_((float)scale.getZ()));
        return tag;
    }

    private ITransformf deserializeTransform(ListNBT tag) {
        if (tag.isEmpty() || tag.size() < 9) {
            return SkinTransform.IDENTITY;
        }
        float tx = tag.func_150308_e(0);
        float ty = tag.func_150308_e(1);
        float tz = tag.func_150308_e(2);
        Vector3f translate = new Vector3f(tx, ty, tz);
        float rx = tag.func_150308_e(3);
        float ry = tag.func_150308_e(4);
        float rz = tag.func_150308_e(5);
        Vector3f rotation = new Vector3f(rx, ry, rz);
        float sx = tag.func_150308_e(6);
        float sy = tag.func_150308_e(7);
        float sz = tag.func_150308_e(8);
        Vector3f scale = new Vector3f(sx, sy, sz);
        return SkinTransform.create(translate, rotation, scale);
    }
}

