/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.entity;

import moe.plushie.armourers_workshop.api.common.IEntityHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ABI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.item.option.MannequinToolOptions;
import moe.plushie.armourers_workshop.core.texture.PlayerTextureDescriptor;
import moe.plushie.armourers_workshop.init.ModEntitySerializers;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutorIO;
import moe.plushie.armourers_workshop.init.platform.MenuManager;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import moe.plushie.armourers_workshop.utils.TrigUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MannequinEntity
extends ArmorStandEntity
implements IEntityHandler {
    public static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    public static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    public static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    public static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    public static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    public static final EntitySize MARKER_DIMENSIONS = new EntitySize(0.0f, 0.0f, true);
    public static final EntitySize BABY_DIMENSIONS = EntitySize.func_220314_b((float)0.5f, (float)1.0f);
    public static final EntitySize STANDING_DIMENSIONS = EntitySize.func_220314_b((float)0.6f, (float)1.88f);
    public static final DataParameter<Boolean> DATA_IS_CHILD = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<Boolean> DATA_IS_FLYING = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<Boolean> DATA_IS_GHOST = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<Boolean> DATA_IS_VISIBLE = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<Float> DATA_SCALE = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.FLOAT);
    public static final DataParameter<Boolean> DATA_EXTRA_RENDERER = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.BOOLEAN);
    public static final DataParameter<PlayerTextureDescriptor> DATA_TEXTURE = EntityDataManager.func_187226_a(MannequinEntity.class, ModEntitySerializers.PLAYER_TEXTURE);
    private boolean isDropEquipment = false;
    private AxisAlignedBB boundingBoxForCulling;

    public MannequinEntity(EntityType<? extends MannequinEntity> entityType, World level) {
        super(entityType, level);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_IS_CHILD, (Object)false);
        this.field_70180_af.func_187214_a(DATA_IS_FLYING, (Object)false);
        this.field_70180_af.func_187214_a(DATA_IS_GHOST, (Object)false);
        this.field_70180_af.func_187214_a(DATA_IS_VISIBLE, (Object)true);
        this.field_70180_af.func_187214_a(DATA_EXTRA_RENDERER, (Object)true);
        this.field_70180_af.func_187214_a(DATA_SCALE, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(DATA_TEXTURE, (Object)PlayerTextureDescriptor.EMPTY);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.readExtendedData(tag);
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        this.addExtendedData(tag);
    }

    public void readExtendedData(CompoundNBT tag) {
        this.field_70180_af.func_187227_b(DATA_IS_CHILD, (Object)OptionalAPI.getOptionalBoolean(tag, "Small", false));
        this.field_70180_af.func_187227_b(DATA_IS_FLYING, (Object)OptionalAPI.getOptionalBoolean(tag, "Flying", false));
        this.field_70180_af.func_187227_b(DATA_IS_GHOST, (Object)OptionalAPI.getOptionalBoolean(tag, "Ghost", false));
        this.field_70180_af.func_187227_b(DATA_IS_VISIBLE, (Object)OptionalAPI.getOptionalBoolean(tag, "ModelVisible", true));
        this.field_70180_af.func_187227_b(DATA_EXTRA_RENDERER, (Object)OptionalAPI.getOptionalBoolean(tag, "ExtraRender", true));
        this.field_70180_af.func_187227_b(DATA_SCALE, (Object)Float.valueOf(OptionalAPI.getOptionalFloat(tag, "Scale", 1.0f)));
        this.field_70180_af.func_187227_b(DATA_TEXTURE, (Object)OptionalAPI.getOptionalTextureDescriptor(tag, "Texture", PlayerTextureDescriptor.EMPTY));
        this.readCustomPose(tag.func_74775_l("Pose"));
    }

    public void addExtendedData(CompoundNBT tag) {
        OptionalAPI.putOptionalBoolean(tag, "Small", (Boolean)this.field_70180_af.func_187225_a(DATA_IS_CHILD), false);
        OptionalAPI.putOptionalBoolean(tag, "Flying", (Boolean)this.field_70180_af.func_187225_a(DATA_IS_FLYING), false);
        OptionalAPI.putOptionalBoolean(tag, "Ghost", (Boolean)this.field_70180_af.func_187225_a(DATA_IS_GHOST), false);
        OptionalAPI.putOptionalBoolean(tag, "ModelVisible", (Boolean)this.field_70180_af.func_187225_a(DATA_IS_VISIBLE), true);
        OptionalAPI.putOptionalBoolean(tag, "ExtraRender", (Boolean)this.field_70180_af.func_187225_a(DATA_EXTRA_RENDERER), true);
        OptionalAPI.putOptionalFloat(tag, "Scale", this.func_213355_cm(), 1.0f);
        OptionalAPI.putOptionalTextureDescriptor(tag, "Texture", this.getTextureDescriptor(), PlayerTextureDescriptor.EMPTY);
        tag.func_218657_a("Pose", (INBT)this.saveCustomPose());
    }

    public void func_184206_a(DataParameter<?> dataParameter) {
        if (DATA_IS_CHILD.equals(dataParameter)) {
            this.func_213323_x_();
        }
        if (DATA_SCALE.equals(dataParameter)) {
            this.func_213323_x_();
        }
        super.func_184206_a(dataParameter);
    }

    public boolean isModelVisible() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_VISIBLE);
    }

    public void setModelVisible(boolean value) {
        this.field_70180_af.func_187227_b(DATA_IS_VISIBLE, (Object)value);
    }

    public float func_213355_cm() {
        return ((Float)this.field_70180_af.func_187225_a(DATA_SCALE)).floatValue();
    }

    public boolean func_175410_n() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_CHILD);
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean isFakeFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_FLYING);
    }

    public boolean func_241845_aY() {
        return this.func_70089_S() && (Boolean)this.field_70180_af.func_187225_a(DATA_IS_GHOST) == false;
    }

    public EntitySize func_213305_a(Pose pose) {
        if (this.func_181026_s()) {
            return MARKER_DIMENSIONS;
        }
        EntitySize entitySize = STANDING_DIMENSIONS;
        if (this.func_70631_g_()) {
            entitySize = BABY_DIMENSIONS;
        }
        return entitySize.func_220313_a(this.func_213355_cm());
    }

    public float func_213348_b(Pose pose, EntitySize entitySize) {
        float eyeHeight = 1.62f;
        if (this.func_70631_g_()) {
            eyeHeight = 0.88f;
        }
        return eyeHeight * this.func_213355_cm();
    }

    @Override
    public ItemStack getCustomPickResult(RayTraceResult target) {
        ItemStack itemStack = new ItemStack((IItemProvider)ModItems.MANNEQUIN.get());
        if (EnvironmentExecutorIO.hasSprintDown()) {
            CompoundNBT entityTag = new CompoundNBT();
            this.func_213281_b(entityTag);
            itemStack.func_196082_o().func_218657_a("EntityTag", (INBT)entityTag);
        }
        return itemStack;
    }

    public void func_181013_g(float f) {
        super.func_181013_g(f);
        PropertyProvider.setYRot((Entity)this, f);
        this.field_70761_aq = f;
    }

    public void func_70107_b(double d, double e, double f) {
        super.func_70107_b(d, e, f);
        this.boundingBoxForCulling = null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.isDropEquipment = false;
        boolean flag = this.func_70089_S();
        boolean flag1 = super.func_70097_a(source, amount);
        if (!this.isDropEquipment && flag != this.func_70089_S()) {
            this.func_213816_g(source);
        }
        return flag1;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d pos, Hand hand) {
        if (this.func_181026_s()) {
            return ActionResultType.PASS;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (ABI.is(itemStack, (Item)ModItems.MANNEQUIN_TOOL.get())) {
            return ActionResultType.PASS;
        }
        if (ABI.is(itemStack, Items.field_151057_cb)) {
            ITextComponent customName = null;
            if (itemStack.func_82837_s() && !player.func_226563_dT_()) {
                customName = itemStack.func_200301_q();
            }
            this.func_200203_b(customName);
            return ActionResultType.func_233537_a_((boolean)PropertyProvider.getLevel((Entity)this).func_201670_d());
        }
        if (player.func_226563_dT_()) {
            double ry = TrigUtils.getAngleDegrees(player.func_226277_ct_(), player.func_226281_cx_(), this.func_226277_ct_(), this.func_226281_cx_()) + 90.0;
            Rotations rotations = this.func_175408_t();
            float yRot = PropertyProvider.getYRot((Entity)this);
            this.func_175424_b(new Rotations(rotations.func_179415_b(), (float)ry - yRot, rotations.func_179413_d()));
            return ActionResultType.func_233537_a_((boolean)PropertyProvider.getLevel((Entity)this).func_201670_d());
        }
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)this);
        if (wardrobe != null && wardrobe.isEditable(player)) {
            MenuManager.openMenu(ModMenuTypes.WARDROBE, player, wardrobe);
            return ActionResultType.func_233537_a_((boolean)PropertyProvider.getLevel((Entity)this).func_201670_d());
        }
        return ActionResultType.PASS;
    }

    public void func_213815_f(DamageSource source) {
        PlayerEntity player = null;
        if (source.func_76346_g() instanceof PlayerEntity) {
            player = (PlayerEntity)source.func_76346_g();
        }
        if (player != null && !moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.PropertyProvider.getAbilities((PlayerEntity)player).field_75098_d) {
            Block.func_180635_a((World)PropertyProvider.getLevel((Entity)this), (BlockPos)this.func_233580_cy_(), (ItemStack)this.createMannequinStack());
        }
        this.func_213816_g(source);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        this.isDropEquipment = true;
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)this);
        if (wardrobe != null) {
            wardrobe.dropAll(arg_0 -> ((MannequinEntity)this).func_199701_a_(arg_0));
        }
    }

    protected ItemStack createMannequinStack() {
        ItemStack itemStack = new ItemStack((IItemProvider)ModItems.MANNEQUIN.get());
        CompoundNBT entityTag = itemStack.func_190925_c("EntityTag");
        OptionalAPI.putOptionalFloat(entityTag, "Scale", this.func_213355_cm(), 1.0f);
        OptionalAPI.putOptionalTextureDescriptor(entityTag, "Texture", this.getTextureDescriptor(), PlayerTextureDescriptor.EMPTY);
        return itemStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        if (this.boundingBoxForCulling != null) {
            return this.boundingBoxForCulling;
        }
        float f = this.func_213355_cm();
        this.boundingBoxForCulling = this.func_174813_aQ().func_72314_b((double)(f * 3.0f), (double)(f * 2.0f), (double)(f * 2.5f));
        return this.boundingBoxForCulling;
    }

    public PlayerTextureDescriptor getTextureDescriptor() {
        return (PlayerTextureDescriptor)this.field_70180_af.func_187225_a(DATA_TEXTURE);
    }

    public void setTextureDescriptor(PlayerTextureDescriptor descriptor) {
        this.field_70180_af.func_187227_b(DATA_TEXTURE, (Object)descriptor);
    }

    public boolean isExtraRenderer() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_EXTRA_RENDERER);
    }

    public void setExtraRenderer(boolean value) {
        this.field_70180_af.func_187227_b(DATA_EXTRA_RENDERER, (Object)value);
    }

    public IInventory getInventory() {
        return new Inventory(new ItemStack[]{this.func_184614_ca(), this.func_184592_cb()}){

            public void func_70299_a(int index, ItemStack itemStack) {
                super.func_70299_a(index, itemStack);
                MannequinEntity.this.func_184201_a(EquipmentSlotType.values()[index], itemStack);
            }
        };
    }

    public CompoundNBT saveCustomPose() {
        CompoundNBT tag = new CompoundNBT();
        OptionalAPI.putOptionalRotations(tag, "Head", (Rotations)this.field_70180_af.func_187225_a(field_184802_b), DEFAULT_HEAD_POSE);
        OptionalAPI.putOptionalRotations(tag, "Body", (Rotations)this.field_70180_af.func_187225_a(field_184803_c), DEFAULT_BODY_POSE);
        OptionalAPI.putOptionalRotations(tag, "LeftArm", (Rotations)this.field_70180_af.func_187225_a(field_184804_d), DEFAULT_LEFT_ARM_POSE);
        OptionalAPI.putOptionalRotations(tag, "RightArm", (Rotations)this.field_70180_af.func_187225_a(field_184805_e), DEFAULT_RIGHT_ARM_POSE);
        OptionalAPI.putOptionalRotations(tag, "LeftLeg", (Rotations)this.field_70180_af.func_187225_a(field_184806_f), DEFAULT_LEFT_LEG_POSE);
        OptionalAPI.putOptionalRotations(tag, "RightLeg", (Rotations)this.field_70180_af.func_187225_a(field_184807_g), DEFAULT_RIGHT_LEG_POSE);
        return tag;
    }

    public void readCustomPose(CompoundNBT tag) {
        this.func_175415_a(OptionalAPI.getOptionalRotations(tag, "Head", DEFAULT_HEAD_POSE));
        this.func_175424_b(OptionalAPI.getOptionalRotations(tag, "Body", DEFAULT_BODY_POSE));
        this.func_175405_c(OptionalAPI.getOptionalRotations(tag, "LeftArm", DEFAULT_LEFT_ARM_POSE));
        this.func_175428_d(OptionalAPI.getOptionalRotations(tag, "RightArm", DEFAULT_RIGHT_ARM_POSE));
        this.func_175417_e(OptionalAPI.getOptionalRotations(tag, "LeftLeg", DEFAULT_LEFT_LEG_POSE));
        this.func_175427_f(OptionalAPI.getOptionalRotations(tag, "RightLeg", DEFAULT_RIGHT_LEG_POSE));
    }

    public void saveMannequinToolData(CompoundNBT entityTag) {
        this.addExtendedData(entityTag);
    }

    public void readMannequinToolData(CompoundNBT entityTag, ItemStack itemStack) {
        INBT oldValue;
        CompoundNBT newEntityTag = new CompoundNBT();
        if (((Boolean)MannequinToolOptions.CHANGE_OPTION.get(itemStack)).booleanValue()) {
            newEntityTag.func_197643_a(entityTag);
            newEntityTag.func_82580_o("Scale");
            newEntityTag.func_82580_o("Pose");
            newEntityTag.func_82580_o("Texture");
        }
        if (((Boolean)MannequinToolOptions.CHANGE_SCALE.get(itemStack)).booleanValue() && (oldValue = entityTag.func_74781_a("Scale")) != null) {
            newEntityTag.func_218657_a("Scale", oldValue);
        }
        if (((Boolean)MannequinToolOptions.CHANGE_ROTATION.get(itemStack)).booleanValue()) {
            oldValue = entityTag.func_74775_l("Pose");
            if (((Boolean)MannequinToolOptions.MIRROR_MODE.get(itemStack)).booleanValue() && !oldValue.isEmpty()) {
                CompoundNBT newPoseTag = oldValue.func_74737_b();
                DataSerializers.mirrorRotations((CompoundNBT)oldValue, "Head", DEFAULT_HEAD_POSE, newPoseTag, "Head", DEFAULT_HEAD_POSE);
                DataSerializers.mirrorRotations((CompoundNBT)oldValue, "Body", DEFAULT_BODY_POSE, newPoseTag, "Body", DEFAULT_BODY_POSE);
                DataSerializers.mirrorRotations((CompoundNBT)oldValue, "RightArm", DEFAULT_RIGHT_ARM_POSE, newPoseTag, "LeftArm", DEFAULT_LEFT_ARM_POSE);
                DataSerializers.mirrorRotations((CompoundNBT)oldValue, "LeftArm", DEFAULT_LEFT_ARM_POSE, newPoseTag, "RightArm", DEFAULT_RIGHT_ARM_POSE);
                DataSerializers.mirrorRotations((CompoundNBT)oldValue, "RightLeg", DEFAULT_RIGHT_LEG_POSE, newPoseTag, "LeftLeg", DEFAULT_LEFT_LEG_POSE);
                DataSerializers.mirrorRotations((CompoundNBT)oldValue, "LeftLeg", DEFAULT_LEFT_LEG_POSE, newPoseTag, "RightLeg", DEFAULT_RIGHT_LEG_POSE);
                oldValue = newPoseTag;
            }
            newEntityTag.func_218657_a("Pose", oldValue);
        }
        if (((Boolean)MannequinToolOptions.CHANGE_TEXTURE.get(itemStack)).booleanValue() && (oldValue = entityTag.func_74781_a("Texture")) != null) {
            newEntityTag.func_218657_a("Texture", oldValue);
        }
        this.readExtendedData(newEntityTag);
    }
}

