/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.item;

import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class SkinUnlockItem
extends FlavouredItem {
    private final SkinSlotType slotType;

    public SkinUnlockItem(SkinSlotType slotType, Item.Properties properties) {
        super(properties);
        this.slotType = slotType;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (level.func_201670_d()) {
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        ISkinType skinType = this.slotType.getSkinType();
        SkinWardrobe wardrobe = SkinWardrobe.of((Entity)player);
        if (wardrobe == null || skinType == null) {
            return ActionResult.func_226251_d_((Object)itemStack);
        }
        IFormattableTextComponent skinName = TranslateUtils.Name.of(skinType);
        if (wardrobe.getUnlockedSize(this.slotType) >= this.slotType.getMaxSize()) {
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.slotUnlockedFailed", skinName));
            return ActionResult.func_226251_d_((Object)itemStack);
        }
        int count = wardrobe.getUnlockedSize(this.slotType) + 1;
        wardrobe.setUnlockedSize(this.slotType, count);
        wardrobe.broadcast();
        SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.slotUnlocked", skinName, Integer.toString(count)));
        ItemStack resultStack = itemStack.func_77946_l();
        resultStack.func_190918_g(1);
        player.func_184611_a(hand, resultStack);
        return ActionResult.func_226249_b_((Object)itemStack);
    }
}

