/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.menu;

import moe.plushie.armourers_workshop.api.common.IContainerLevelAccess;
import moe.plushie.armourers_workshop.core.blockentity.HologramProjectorBlockEntity;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class HologramProjectorMenu
extends AbstractBlockEntityMenu<HologramProjectorBlockEntity> {
    private final PlayerInventory playerInventory;
    private final IInventory inventory;
    private int group;

    public HologramProjectorMenu(ContainerType<?> menuType, Block block, int containerId, PlayerInventory playerInventory, IContainerLevelAccess worldPos) {
        super((ContainerType)menuType, block, containerId, worldPos);
        this.playerInventory = playerInventory;
        this.inventory = ((HologramProjectorBlockEntity)this.blockEntity).getInventory();
        this.reload(0, 0, 240, 240);
    }

    public void reload(int inventoryX, int inventoryY, int width, int height) {
        this.field_75151_b.clear();
        this.addPlayerSlots((IInventory)this.playerInventory, inventoryX + 8, inventoryY + 16, this.visibleSlotBuilder(this::shouldRenderInventory));
        if (this.inventory != null) {
            this.addSkinSlots(this.inventory, 1, width, height);
        }
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        return this.quickMoveStack(player, index, this.field_75151_b.size());
    }

    public boolean shouldRenderInventory() {
        return this.getGroup() == 1;
    }

    protected void addSkinSlots(IInventory inventory, int group, int width, int height) {
        int size = inventory.func_70302_i_();
        int slotsX = (width - 176) / 2 + 80;
        int slotsY = 16;
        for (int i = 0; i < size; ++i) {
            int tx = slotsX + i * 19;
            this.func_75146_a(new GroupSlot(inventory, group, i, tx, slotsY));
        }
    }

    public final class GroupSlot
    extends Slot {
        private final int group;

        public GroupSlot(IInventory inventory, int group, int index, int x, int y) {
            super(inventory, index, x, y);
            this.group = group;
        }

        public boolean func_111238_b() {
            return HologramProjectorMenu.this.getGroup() == this.group;
        }
    }
}

