/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.common.IConfigurableTool;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;

public class UpdateConfigurableToolPacket
extends CustomPacket {
    private final Hand hand;
    private final ItemStack itemStack;

    public UpdateConfigurableToolPacket(PacketBuffer buffer) {
        this.hand = (Hand)buffer.func_179257_a(Hand.class);
        this.itemStack = buffer.func_150791_c();
    }

    public UpdateConfigurableToolPacket(Hand hand, ItemStack itemStack) {
        this.hand = hand;
        this.itemStack = itemStack;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.hand);
        buffer.func_150788_a(this.itemStack);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        ItemStack oldItemStack = player.func_184586_b(this.hand);
        IConfigurableTool configurableTool = ObjectUtils.safeCast(oldItemStack.func_77973_b(), IConfigurableTool.class);
        if (configurableTool == null) {
            this.abort((PlayerEntity)player, "update", "tried change unsupported item type.");
            return;
        }
        if (!oldItemStack.func_77973_b().equals(this.itemStack.func_77973_b())) {
            this.abort((PlayerEntity)player, "update", "tried change item type.");
            return;
        }
        ItemStack newItemStack = oldItemStack.func_77946_l();
        this.copyTo(this.itemStack, newItemStack, "Options");
        this.copyTo(this.itemStack, newItemStack, "Color");
        player.func_184611_a(this.hand, newItemStack);
    }

    private void copyTo(ItemStack fromItemStack, ItemStack toItemStack, String key) {
        CompoundNBT nbt = fromItemStack.func_77978_p();
        INBT value = null;
        if (nbt != null) {
            value = nbt.func_74781_a(key);
        }
        if (value != null) {
            CompoundNBT itemTag = toItemStack.func_196082_o();
            itemTag.func_218657_a(key, value);
        } else {
            CompoundNBT itemTag = toItemStack.func_77978_p();
            if (itemTag != null) {
                itemTag.func_82580_o(key);
            }
        }
    }

    private void abort(PlayerEntity player, String op, String reason) {
        String playerName = player.func_195047_I_();
        ModLog.info("abort {} request of the '{}', reason: '{}', from: '{}', to: '{}'", op, playerName, reason, player.func_184586_b(this.hand), this.itemStack);
    }
}

