/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import java.util.HashMap;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentProvider;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentTypes;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class UpdateSkinDocumentPacket
extends CustomPacket {
    private static final HashMap<Class<? extends Action>, Mode> ALL_ACTIONS = new HashMap();
    private String operator;
    private final BlockPos pos;
    private final Action action;

    public UpdateSkinDocumentPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.operator = buffer.func_218666_n();
        Mode mode = (Mode)buffer.func_179257_a(Mode.class);
        this.action = mode.read(buffer);
    }

    public UpdateSkinDocumentPacket(TileEntity entity, Action action) {
        this.pos = entity.func_174877_v();
        this.action = action;
        this.operator = "";
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.func_180714_a(this.operator);
        buffer.func_179249_a((Enum)ALL_ACTIONS.getOrDefault(this.action.getClass(), Mode.CHANGE_TYPE));
        this.action.encode(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        String playerName = player.func_145748_c_().getString();
        TileEntity blockEntity = player.func_71121_q().func_175625_s(this.pos);
        if (blockEntity instanceof SkinDocumentProvider) {
            ModLog.debug("the document {} accepted for '{}'", this.action, playerName);
            SkinDocument document = ((SkinDocumentProvider)blockEntity).getDocument();
            document.beginEditing();
            this.action.execute(document, (PlayerEntity)player);
            document.endEditing();
            if (!(this.action instanceof ChangeTypeAction)) {
                this.operator = player.func_189512_bd();
                NetworkManager.sendToTrackingBlock(this, blockEntity);
            }
        }
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        if (this.operator.equals(player.func_189512_bd())) {
            return;
        }
        TileEntity blockEntity = PropertyProvider.getLevel((Entity)player).func_175625_s(this.pos);
        if (blockEntity instanceof SkinDocumentProvider) {
            ModLog.debug("the document {} accepted for server", this.action);
            SkinDocument document = ((SkinDocumentProvider)blockEntity).getDocument();
            document.beginEditing();
            this.action.execute(document, player);
            document.endEditing();
        }
    }

    public static enum Mode {
        CHANGE_TYPE(ChangeTypeAction.class, ChangeTypeAction::new),
        UPDATE_SETTINGS(UpdateSettingsAction.class, UpdateSettingsAction::new),
        UPDATE_PROPERTIES(UpdatePropertiesAction.class, UpdatePropertiesAction::new),
        INSERT_NODE(InsertNodeAction.class, InsertNodeAction::new),
        UPDATE_NODE(UpdateNodeAction.class, UpdateNodeAction::new),
        REMOVE_NODE(RemoveNodeAction.class, RemoveNodeAction::new),
        MOVE_NODE(MoveNodeAction.class, MoveNodeAction::new);

        final Function<PacketBuffer, ? extends Action> actionFactory;

        private Mode(Class<? extends Action> actionClass, Function<PacketBuffer, Action> actionFactory) {
            this.actionFactory = actionFactory;
            ALL_ACTIONS.put(actionClass, this);
        }

        public Action read(PacketBuffer buf) {
            return this.actionFactory.apply(buf);
        }
    }

    public static abstract class Action {
        public abstract void encode(PacketBuffer var1);

        public abstract void execute(SkinDocument var1, PlayerEntity var2);

        protected String makeDescription(String action, Object ... args) {
            StringBuilder builder = new StringBuilder();
            builder.append(action);
            builder.append("(");
            for (int i = 0; i < args.length; i += 2) {
                if (i != 0) {
                    builder.append(",");
                }
                builder.append(args[i]);
                builder.append(":");
                builder.append(args[i + 1]);
            }
            builder.append(")");
            return builder.toString();
        }
    }

    public static class ChangeTypeAction
    extends Action {
        private final SkinDocumentType type;

        public ChangeTypeAction(SkinDocumentType type) {
            this.type = type;
        }

        public ChangeTypeAction(PacketBuffer buf) {
            this.type = SkinDocumentTypes.byName(buf.func_218666_n());
        }

        @Override
        public void encode(PacketBuffer buffer) {
            buffer.func_180714_a(this.type.getRegistryName().toString());
        }

        @Override
        public void execute(SkinDocument document, PlayerEntity player) {
            document.setType(this.type);
        }

        public String toString() {
            return this.makeDescription("changeType", "type", this.type.getRegistryName());
        }
    }

    public static class MoveNodeAction
    extends Action {
        private final String id;
        private final String targetId;
        private final int targetIndex;

        public MoveNodeAction(String id, String targetId, int targetIndex) {
            this.id = id;
            this.targetId = targetId;
            this.targetIndex = targetIndex;
        }

        public MoveNodeAction(PacketBuffer buf) {
            this.id = buf.func_218666_n();
            this.targetId = buf.func_218666_n();
            this.targetIndex = buf.readInt();
        }

        @Override
        public void encode(PacketBuffer buf) {
            buf.func_180714_a(this.id);
            buf.func_180714_a(this.targetId);
            buf.writeInt(this.targetIndex);
        }

        @Override
        public void execute(SkinDocument document, PlayerEntity player) {
            SkinDocumentNode parent = document.nodeById(this.id);
            SkinDocumentNode target = document.nodeById(this.targetId);
            if (parent != null && target != null) {
                parent.moveTo(target, this.targetIndex);
            }
        }

        public String toString() {
            return this.makeDescription("moveNode", "id", this.id, "tid", this.targetId, "ti", this.targetIndex);
        }
    }

    public static class RemoveNodeAction
    extends Action {
        private final String id;

        public RemoveNodeAction(String id) {
            this.id = id;
        }

        public RemoveNodeAction(PacketBuffer buf) {
            this.id = buf.func_218666_n();
        }

        @Override
        public void encode(PacketBuffer buf) {
            buf.func_180714_a(this.id);
        }

        @Override
        public void execute(SkinDocument document, PlayerEntity player) {
            SkinDocumentNode target = document.nodeById(this.id);
            if (target != null) {
                target.removeFromParent();
            }
        }

        public String toString() {
            return this.makeDescription("removeNode", "id", this.id);
        }
    }

    public static class UpdateNodeAction
    extends Action {
        private final String id;
        private final CompoundNBT tag;

        public UpdateNodeAction(String id, CompoundNBT tag) {
            this.id = id;
            this.tag = tag;
        }

        public UpdateNodeAction(PacketBuffer buf) {
            this.id = buf.func_218666_n();
            this.tag = buf.func_150793_b();
        }

        @Override
        public void encode(PacketBuffer buf) {
            buf.func_180714_a(this.id);
            buf.func_150786_a(this.tag);
        }

        @Override
        public void execute(SkinDocument document, PlayerEntity player) {
            SkinDocumentNode target = document.nodeById(this.id);
            if (target != null) {
                target.deserializeNBT(this.tag);
            }
        }

        public String toString() {
            return this.makeDescription("updateNode", "id", this.id, "tag", this.tag);
        }
    }

    public static class InsertNodeAction
    extends Action {
        private final String id;
        private final int targetIndex;
        private final CompoundNBT tag;

        public InsertNodeAction(String id, int targetIndex, CompoundNBT tag) {
            this.id = id;
            this.targetIndex = targetIndex;
            this.tag = tag;
        }

        public InsertNodeAction(PacketBuffer buf) {
            this.id = buf.func_218666_n();
            this.targetIndex = buf.readInt();
            this.tag = buf.func_150793_b();
        }

        @Override
        public void encode(PacketBuffer buf) {
            buf.func_180714_a(this.id);
            buf.writeInt(this.targetIndex);
            buf.func_150786_a(this.tag);
        }

        @Override
        public void execute(SkinDocument document, PlayerEntity player) {
            SkinDocumentNode target = document.nodeById(this.id);
            if (target != null) {
                SkinDocumentNode newValue = new SkinDocumentNode(this.tag);
                target.insertAtIndex(newValue, this.targetIndex);
            }
        }

        public String toString() {
            return this.makeDescription("insertNode", "id", this.id, "ti", this.targetIndex, "tag", this.tag);
        }
    }

    public static class UpdatePropertiesAction
    extends Action {
        private final CompoundNBT tag;

        public UpdatePropertiesAction(CompoundNBT tag) {
            this.tag = tag;
        }

        public UpdatePropertiesAction(PacketBuffer buf) {
            this.tag = buf.func_150793_b();
        }

        @Override
        public void encode(PacketBuffer buf) {
            buf.func_150786_a(this.tag);
        }

        @Override
        public void execute(SkinDocument document, PlayerEntity player) {
            document.updateProperties(this.tag);
        }

        public String toString() {
            return this.makeDescription("updateProperties", "tag", this.tag);
        }
    }

    public static class UpdateSettingsAction
    extends Action {
        private final CompoundNBT tag;

        public UpdateSettingsAction(CompoundNBT tag) {
            this.tag = tag;
        }

        public UpdateSettingsAction(PacketBuffer buf) {
            this.tag = buf.func_150793_b();
        }

        @Override
        public void encode(PacketBuffer buf) {
            buf.func_150786_a(this.tag);
        }

        @Override
        public void execute(SkinDocument document, PlayerEntity player) {
            document.updateSettings(this.tag);
        }

        public String toString() {
            return this.makeDescription("updateSettings", "tag", this.tag);
        }
    }
}

