/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.registry;

import java.util.LinkedHashMap;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.util.ResourceLocation;

public class ModRegistry<TYPE extends IRegistryItem> {
    private final String name;
    private final LinkedHashMap<ResourceLocation, TYPE> registryMap = new LinkedHashMap();

    public ModRegistry(String name) {
        this.name = name;
    }

    public boolean register(TYPE value) {
        if (value == null) {
            ModLog.warn("[" + this.name + "] A mod tried to register a null value.", new Object[0]);
            return false;
        }
        if (value.getRegistryName() == null || value.getRegistryName().toString().trim().isEmpty()) {
            ModLog.warn("[" + this.name + "] A mod tried to register with an invalid registry key.", new Object[0]);
            return false;
        }
        if (this.registryMap.containsKey(value.getRegistryName())) {
            ModLog.warn("[" + this.name + "] A mod tried to register with a key that is in use.", new Object[0]);
            return false;
        }
        ModLog.info(String.format("[" + this.name + "] Registering: %s as %s.", value.getName(), value.getRegistryName()), new Object[0]);
        this.registryMap.put(value.getRegistryName(), value);
        return true;
    }

    public TYPE get(ResourceLocation key) {
        return (TYPE)((IRegistryItem)this.registryMap.get(key));
    }

    public static interface IRegistryItem {
        public ResourceLocation getRegistryName();

        public String getName();
    }

    public static class RegistryItem
    implements IRegistryItem {
        private final String name;

        public RegistryItem(String name) {
            this.name = name;
        }

        @Override
        public ResourceLocation getRegistryName() {
            return new ResourceLocation("LibModInfo.ID", this.name);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

