/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin;

import moe.plushie.armourers_workshop.api.skin.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.skin.ISkinToolType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.data.ItemStackStorage;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.skin.SkinOptions;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;

public class SkinDescriptor
implements ISkinDescriptor {
    public static final SkinDescriptor EMPTY = new SkinDescriptor("");
    private final String identifier;
    private final ISkinType type;
    private final SkinOptions options;
    private final ColorScheme colorScheme;
    private ItemStack skinItemStack;

    public SkinDescriptor(String identifier) {
        this(identifier, SkinTypes.UNKNOWN, SkinOptions.DEFAULT, ColorScheme.EMPTY);
    }

    public SkinDescriptor(String identifier, ISkinType type) {
        this(identifier, type, SkinOptions.DEFAULT, ColorScheme.EMPTY);
    }

    public SkinDescriptor(String identifier, ISkinType type, ColorScheme colorScheme) {
        this(identifier, type, SkinOptions.DEFAULT, colorScheme);
    }

    public SkinDescriptor(String identifier, ISkinType type, SkinOptions options, ColorScheme colorScheme) {
        this.identifier = identifier;
        this.type = type;
        this.options = options;
        this.colorScheme = colorScheme;
    }

    public SkinDescriptor(SkinDescriptor descriptor, ColorScheme colorScheme) {
        this(descriptor.getIdentifier(), descriptor.getType(), descriptor.getOptions(), colorScheme);
    }

    public SkinDescriptor(CompoundNBT tag) {
        this.identifier = tag.func_74779_i("Identifier");
        this.type = SkinTypes.byName(tag.func_74779_i("SkinType"));
        this.options = OptionalAPI.getOptionalSkinOptions(tag, "SkinOptions", SkinOptions.DEFAULT);
        this.colorScheme = OptionalAPI.getOptionalColorScheme(tag, "SkinDyes", ColorScheme.EMPTY);
    }

    public static SkinDescriptor of(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return EMPTY;
        }
        ItemStackStorage storage = ItemStackStorage.of(itemStack);
        SkinDescriptor descriptor = storage.skinDescriptor;
        if (descriptor != null) {
            return descriptor;
        }
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag == null || !tag.func_74764_b("ArmourersWorkshop")) {
            storage.skinDescriptor = EMPTY;
            return EMPTY;
        }
        storage.skinDescriptor = descriptor = OptionalAPI.getOptionalSkinDescriptor(tag, "ArmourersWorkshop");
        return descriptor;
    }

    public static void setDescriptor(ItemStack itemStack, SkinDescriptor descriptor) {
        if (itemStack.func_190926_b()) {
            return;
        }
        if (descriptor.isEmpty()) {
            itemStack.func_196083_e("ArmourersWorkshop");
            return;
        }
        itemStack.func_77983_a("ArmourersWorkshop", (INBT)descriptor.serializeNBT());
    }

    public boolean accept(ItemStack itemStack) {
        if (itemStack.func_190926_b() || this.isEmpty()) {
            return false;
        }
        ISkinType skinType = this.getType();
        if (skinType == SkinTypes.ITEM) {
            return true;
        }
        if (skinType instanceof ISkinToolType) {
            return ((ISkinToolType)((Object)skinType)).contains(itemStack);
        }
        return false;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (this.isEmpty()) {
            return nbt;
        }
        nbt.func_74778_a("SkinType", this.type.getRegistryName().toString());
        nbt.func_74778_a("Identifier", this.identifier);
        OptionalAPI.putOptionalSkinOptions(nbt, "SkinOptions", this.options, SkinOptions.DEFAULT);
        OptionalAPI.putOptionalColorScheme(nbt, "SkinDyes", this.colorScheme, ColorScheme.EMPTY);
        return nbt;
    }

    public ItemStack sharedItemStack() {
        if (this.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (this.skinItemStack != null) {
            return this.skinItemStack;
        }
        ItemStack itemStack = new ItemStack((IItemProvider)ModItems.SKIN.get());
        SkinDescriptor.setDescriptor(itemStack, this);
        this.skinItemStack = itemStack;
        return itemStack;
    }

    public ItemStack asItemStack() {
        return this.sharedItemStack().func_77946_l();
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public ISkinType getType() {
        return this.type;
    }

    public SkinOptions getOptions() {
        return this.options;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return String.format("%s@%s[%s]", this.identifier, this.type.getRegistryName(), this.type.getId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkinDescriptor that = (SkinDescriptor)o;
        return this.identifier.equals(that.identifier) && this.colorScheme.equals(that.colorScheme);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

