/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.cube;

import java.util.Collection;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeProvider;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.OpenPoseStack;
import moe.plushie.armourers_workshop.utils.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import org.jetbrains.annotations.Nullable;

public abstract class SkinCubes
implements ISkinCubeProvider {
    protected final OpenPoseStack poseStack = new OpenPoseStack();
    protected final SkinUsedCounter usedCounter = new SkinUsedCounter();

    public void forEach(Consumer<SkinCube> consumer) {
        int count = this.getCubeTotal();
        for (int i = 0; i < count; ++i) {
            consumer.accept(this.getCube(i));
        }
    }

    public OpenVoxelShape getShape() {
        OpenVoxelShape shape = OpenVoxelShape.empty();
        int total = this.getCubeTotal();
        if (total == 0) {
            return shape;
        }
        for (int i = 0; i < total; ++i) {
            SkinCube cube = this.getCube(i);
            Rectangle3f rect = cube.getShape();
            SkinTransform transform = cube.getTransform();
            if (transform.isIdentity()) {
                shape.add(rect);
                continue;
            }
            this.poseStack.pushPose();
            OpenVoxelShape shape1 = OpenVoxelShape.box(rect);
            transform.apply(this.poseStack);
            shape1.mul(this.poseStack.last().pose());
            this.poseStack.popPose();
            shape.add(shape1);
        }
        shape.optimize();
        return shape;
    }

    public SkinUsedCounter getUsedCounter() {
        return this.usedCounter;
    }

    @Override
    public abstract SkinCube getCube(int var1);

    @Nullable
    public Collection<ISkinCubeType> getCubeTypes() {
        return null;
    }

    public String toString() {
        return ObjectUtils.makeDescription(this, "total", this.getCubeTotal());
    }
}

