/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.core.data.transform.SkinItemTransforms;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentListener;
import net.minecraft.nbt.CompoundNBT;

public class SkinDocumentSettings {
    private float scale = 1.0f;
    private boolean showsOrigin = true;
    private boolean showsHelperModel = true;
    private SkinItemTransforms itemTransforms;
    private SkinDocumentListener listener;

    public SkinDocumentSettings() {
    }

    public SkinDocumentSettings(CompoundNBT tag) {
        this.scale = OptionalAPI.getOptionalFloat(tag, "Scale", 1.0f);
        this.showsHelperModel = OptionalAPI.getOptionalBoolean(tag, "HelperModel", true);
        this.showsOrigin = OptionalAPI.getOptionalBoolean(tag, "Origin", true);
        this.itemTransforms = OptionalAPI.getOptionalItemTransforms(tag, "ItemTransforms", null);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        OptionalAPI.putOptionalFloat(tag, "Scale", this.scale, 1.0f);
        OptionalAPI.putOptionalBoolean(tag, "HelperModel", this.showsHelperModel, true);
        OptionalAPI.putOptionalBoolean(tag, "Origin", this.showsOrigin, true);
        OptionalAPI.putOptionalItemTransforms(tag, "ItemTransforms", this.itemTransforms, null);
        return tag;
    }

    public void deserializeNBT(CompoundNBT tag) {
        if (tag.func_74764_b("Scale")) {
            this.scale = tag.func_74760_g("Scale");
        }
        if (tag.func_74764_b("HelperModel")) {
            this.showsHelperModel = tag.func_74767_n("HelperModel");
        }
        if (tag.func_74764_b("Origin")) {
            this.showsHelperModel = tag.func_74767_n("Origin");
        }
        if (tag.func_74764_b("ItemTransforms")) {
            this.itemTransforms = OptionalAPI.getOptionalItemTransforms(tag, "ItemTransforms", null);
        }
    }

    public void setShowsHelperModel(boolean value) {
        this.showsHelperModel = value;
        if (this.listener != null) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("HelperModel", value);
            this.listener.documentDidChangeSettings(tag);
        }
    }

    public boolean showsHelperModel() {
        return this.showsHelperModel;
    }

    public void setShowsOrigin(boolean value) {
        this.showsOrigin = value;
        if (this.listener != null) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74757_a("Origin", value);
            this.listener.documentDidChangeSettings(tag);
        }
    }

    public boolean showsOrigin() {
        return this.showsOrigin;
    }

    public void setItemTransforms(SkinItemTransforms itemTransforms) {
        this.itemTransforms = itemTransforms;
        if (this.listener != null) {
            CompoundNBT tag = new CompoundNBT();
            OptionalAPI.putOptionalItemTransforms(tag, "ItemTransforms", itemTransforms, null);
            this.listener.documentDidChangeSettings(tag);
        }
    }

    public SkinItemTransforms getItemTransforms() {
        return this.itemTransforms;
    }

    protected void setListener(SkinDocumentListener listener) {
        this.listener = listener;
    }

    public static class Keys {
        public static final String SCALE = "Scale";
        public static final String ORIGIN = "Origin";
        public static final String HELPER_MODEL = "HelperModel";
        public static final String ITEM_TRANSFORMS = "ItemTransforms";
    }
}

