/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.document;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.api.registry.IRegistryEntry;
import moe.plushie.armourers_workshop.api.skin.ISkinEquipmentType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.util.ResourceLocation;

public class SkinDocumentType
implements IRegistryEntry {
    private static final ImmutableMap<ISkinPartType, Collection<ISkinPartType>> LINKED_PARTS = new ImmutableMap.Builder().put((Object)SkinPartTypes.BIPPED_CHEST, ObjectUtils.map(SkinPartTypes.BIPPED_TORSO)).put((Object)SkinPartTypes.BIPPED_LEFT_ARM, ObjectUtils.map(SkinPartTypes.BIPPED_LEFT_HAND)).put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, ObjectUtils.map(SkinPartTypes.BIPPED_RIGHT_HAND)).put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, ObjectUtils.map(SkinPartTypes.BIPPED_LEFT_LEG)).put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, ObjectUtils.map(SkinPartTypes.BIPPED_RIGHT_LEG)).put((Object)SkinPartTypes.BIPPED_RIGHT_WING, ObjectUtils.map(SkinPartTypes.BIPPED_RIGHT_PHALANX)).put((Object)SkinPartTypes.BIPPED_LEFT_WING, ObjectUtils.map(SkinPartTypes.BIPPED_LEFT_PHALANX)).put((Object)SkinPartTypes.ITEM_SHIELD, ObjectUtils.map(SkinPartTypes.ITEM_SHIELD1)).put((Object)SkinPartTypes.ITEM_TRIDENT, ObjectUtils.map(SkinPartTypes.ITEM_TRIDENT1)).put((Object)SkinPartTypes.ITEM_FISHING_ROD, ObjectUtils.map(SkinPartTypes.ITEM_FISHING_ROD1)).build();
    private static final ImmutableSet<ISkinPartType> DISABLED_PARTS = new ImmutableSet.Builder().add((Object)SkinPartTypes.BLOCK_MULTI).build();
    private final String name;
    private final ISkinType skinType;
    private final ArrayList<ISkinPartType> skinPartTypes;
    private ResourceLocation registryName;

    public SkinDocumentType(String name, ISkinType type) {
        this.name = name;
        this.skinType = type;
        this.skinPartTypes = this.generatePartTypes(type);
    }

    public String getName() {
        return this.name;
    }

    public ISkinType getSkinType() {
        return this.skinType;
    }

    public List<? extends ISkinPartType> getSkinPartTypes() {
        return this.skinPartTypes;
    }

    public void setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public boolean usesItemTransforms() {
        return this.skinType instanceof ISkinEquipmentType || this.skinType == SkinTypes.ITEM;
    }

    public String toString() {
        return ObjectUtils.makeDescription(this, "name", this.name, "id", this.registryName);
    }

    private ArrayList<ISkinPartType> generatePartTypes(ISkinType type) {
        ArrayList<ISkinPartType> partTypes = new ArrayList<ISkinPartType>();
        for (ISkinPartType iSkinPartType : type.getParts()) {
            if (DISABLED_PARTS.contains((Object)iSkinPartType)) continue;
            Collection linkedParts = (Collection)LINKED_PARTS.get((Object)iSkinPartType);
            partTypes.add(iSkinPartType);
            if (linkedParts == null) continue;
            partTypes.addAll(linkedParts);
        }
        return partTypes;
    }
}

