/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.skin.ISkinPart;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinTransform;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.SkinMarker;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.Nullable;

public class SkinPart
implements ISkinPart {
    protected String name;
    protected ISkinPartType partType;
    protected ISkinTransform transform = SkinTransform.IDENTITY;
    protected SkinProperties properties = SkinProperties.EMPTY;
    private SkinCubes cubeData;
    private Object blobs;
    private HashMap<BlockPos, Rectangle3i> blockBounds;
    private final ArrayList<SkinPart> children = new ArrayList();
    private final ArrayList<SkinMarker> markerBlocks = new ArrayList();

    public SkinPart(ISkinPartType partType, Collection<SkinMarker> markers, SkinCubes cubes) {
        this.partType = partType;
        this.cubeData = cubes;
        this.cubeData.getUsedCounter().addMarkers(markers.size());
        this.markerBlocks.addAll(markers);
    }

    public void addPart(SkinPart part) {
        this.children.add(part);
    }

    public void removePart(SkinPart part) {
        this.children.remove(part);
    }

    public void setProperties(SkinProperties properties) {
        this.properties = properties;
    }

    public SkinProperties getProperties() {
        return this.properties;
    }

    public int getModelCount() {
        return 0;
    }

    public void setSkinPart(ISkinPartType skinPart) {
        this.partType = skinPart;
    }

    public HashMap<BlockPos, Rectangle3i> getBlockBounds() {
        if (this.blockBounds != null) {
            return this.blockBounds;
        }
        HashMap<Long, Rectangle3i> blockGrid = new HashMap<Long, Rectangle3i>();
        this.blockBounds = new HashMap();
        this.cubeData.forEach(cube -> {
            Vector3i pos = cube.getPosition();
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            int tx = MathUtils.floor((float)(x + 8) / 16.0f);
            int ty = MathUtils.floor((float)(y + 8) / 16.0f);
            int tz = MathUtils.floor((float)(z + 8) / 16.0f);
            long key = BlockPos.func_218276_a((int)(-tx), (int)(-ty), (int)tz);
            Rectangle3i rec = new Rectangle3i(-(x - tx * 16) - 1, -(y - ty * 16) - 1, z - tz * 16, 1, 1, 1);
            blockGrid.computeIfAbsent(key, k -> rec).union(rec);
        });
        blockGrid.forEach((key, value) -> this.blockBounds.put(BlockPos.func_218283_e((long)key), (Rectangle3i)value));
        return this.blockBounds;
    }

    public SkinCubes getCubeData() {
        return this.cubeData;
    }

    public void clearCubeData() {
        this.cubeData = null;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setTransform(ISkinTransform transform) {
        this.transform = transform;
    }

    public ISkinTransform getTransform() {
        return this.transform;
    }

    public void setBlobs(Object blobs) {
        this.blobs = blobs;
    }

    public Object getBlobs() {
        return this.blobs;
    }

    @Override
    public ISkinPartType getType() {
        return this.partType;
    }

    public ArrayList<SkinPart> getParts() {
        return this.children;
    }

    public Collection<SkinMarker> getMarkers() {
        return this.markerBlocks;
    }

    public String toString() {
        return ObjectUtils.makeDescription(this, "cubeData", this.cubeData, "markerBlocks", this.markerBlocks, "type", this.partType);
    }

    public static class Builder {
        private final ISkinPartType partType;
        private String name;
        private SkinCubes cubes;
        private ISkinTransform transform = SkinTransform.IDENTITY;
        private ArrayList<SkinMarker> markers = new ArrayList();
        private SkinProperties properties;
        private Object blobs;

        public Builder(ISkinPartType partType) {
            this.partType = partType;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder transform(ISkinTransform transform) {
            if (transform != null) {
                this.transform = transform;
            }
            return this;
        }

        public Builder cubes(SkinCubes cubes) {
            this.cubes = cubes;
            return this;
        }

        public Builder markers(Collection<SkinMarker> markers) {
            if (markers != null) {
                this.markers.addAll(markers);
            }
            return this;
        }

        public Builder properties(SkinProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder blobs(Object blobs) {
            this.blobs = blobs;
            return this;
        }

        public SkinPart build() {
            SkinPart skinPart = new SkinPart(this.partType, this.markers, this.cubes);
            skinPart.setName(this.name);
            skinPart.setTransform(this.transform);
            skinPart.setBlobs(this.blobs);
            return skinPart;
        }
    }
}

