/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk;

import java.util.ArrayList;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.skin.ISkinCubeType;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCube;
import moe.plushie.armourers_workshop.core.skin.cube.SkinCubes;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSelector;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSlice;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.ChunkCubeCoders;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SliceRandomlyAccessor;

public class ChunkCubeSlices
extends SkinCubes {
    private int cubeTotal;
    private final SliceRandomlyAccessor<SkinCube> accessor;
    private final ArrayList<ChunkCubeSelector> selectors;
    private final ChunkPaletteData palette;

    public ChunkCubeSlices(ArrayList<ChunkCubeSelector> selectors, ChunkPaletteData palette) {
        this.palette = palette;
        this.selectors = selectors;
        this.accessor = new SliceRandomlyAccessor<SkinCube>(ObjectUtils.map(selectors, this::build));
    }

    @Override
    public int getCubeTotal() {
        return this.cubeTotal;
    }

    @Override
    public SkinCube getCube(int index) {
        return this.accessor.get(index);
    }

    @Override
    public Collection<ISkinCubeType> getCubeTypes() {
        return ObjectUtils.map(this.selectors, it -> it.section.getCubeType());
    }

    public ChunkPaletteData getPalette() {
        return this.palette;
    }

    public Collection<ChunkCubeSelector> getSelectors() {
        return this.selectors;
    }

    private ChunkCubeSlice build(ChunkCubeSelector selector) {
        int startIndex = this.cubeTotal;
        this.cubeTotal += selector.count;
        return ChunkCubeCoders.createDecoder(startIndex, this.cubeTotal, selector, (ChunkCubeSection.Immutable)selector.section);
    }
}

