/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.v1;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.math.IVector3i;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.api.skin.ISkinCube;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkOutputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.ChunkCubeEncoder;
import net.minecraft.util.Direction;

public class ChunkCubeEncoderV1
extends ChunkCubeEncoder {
    private ISkinCube cube;
    private final LinkedHashMap<IPaintColor, Integer> values = new LinkedHashMap();

    @Override
    public int begin(ISkinCube cube) {
        for (Direction dir : Direction.values()) {
            IPaintColor value = cube.getPaintColor(dir);
            int face = this.values.getOrDefault(value, 0);
            this.values.put(value, face |= 1 << dir.func_176745_a());
        }
        this.cube = cube;
        return this.values.size();
    }

    @Override
    public void end(ChunkPaletteData palette, ChunkOutputStream stream) throws IOException {
        IVector3i pos = this.cube.getPosition();
        stream.writeByte(pos.getX());
        stream.writeByte(pos.getY());
        stream.writeByte(pos.getZ());
        for (Map.Entry<IPaintColor, Integer> entry : this.values.entrySet()) {
            stream.writeByte(entry.getValue());
            stream.writeVariable(palette.writeColor(entry.getKey()));
        }
        this.values.clear();
        this.cube = null;
    }
}

