/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.v2;

import java.util.BitSet;
import java.util.EnumMap;
import moe.plushie.armourers_workshop.api.common.ITextureKey;
import moe.plushie.armourers_workshop.api.painting.IPaintColor;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.core.data.transform.SkinTransform;
import moe.plushie.armourers_workshop.core.skin.face.SkinCubeFace;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkColorSection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSection;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkCubeSelector;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.chunk.ChunkPaletteData;
import moe.plushie.armourers_workshop.core.skin.serializer.v20.coder.ChunkCubeDecoder;
import moe.plushie.armourers_workshop.utils.DirectionUtils;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector2f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;
import moe.plushie.armourers_workshop.utils.texture.TextureBox;
import moe.plushie.armourers_workshop.utils.texture.TextureKey;
import moe.plushie.armourers_workshop.utils.texture.TextureOptions;
import net.minecraft.util.Direction;

public class ChunkCubeDecoderV2
extends ChunkCubeDecoder {
    private Rectangle3f shape = Rectangle3f.ZERO;
    private SkinTransform transform = SkinTransform.IDENTITY;
    protected final BitSet flags = new BitSet();
    protected final EnumMap<Direction, Vector2f> startUVs = new EnumMap(Direction.class);
    protected final EnumMap<Direction, Vector2f> endUVs = new EnumMap(Direction.class);
    protected final EnumMap<Direction, TextureOptions> optionsValues = new EnumMap(Direction.class);
    protected final EnumMap<Direction, ITextureKey> textureKeys = new EnumMap(Direction.class);

    public ChunkCubeDecoderV2(int startIndex, int endIndex, ChunkCubeSelector selector, ChunkCubeSection.Immutable section) {
        super(startIndex, endIndex, selector, section);
    }

    public static int getStride(int options, ChunkPaletteData palette) {
        int faceCount = options & 0xF;
        return ChunkCubeDecoderV2.calcStride(palette.getTextureIndexBytes(), faceCount);
    }

    public static int calcStride(int usedBytes, int size) {
        return 88 + (1 + usedBytes * 2) * size;
    }

    @Override
    public Rectangle3f getShape() {
        if (this.setBit(0)) {
            float x = this.getFloat(0);
            float y = this.getFloat(4);
            float z = this.getFloat(8);
            float width = this.getFloat(12);
            float height = this.getFloat(16);
            float depth = this.getFloat(20);
            this.shape = new Rectangle3f(x, y, z, width, height, depth);
        }
        return this.shape;
    }

    @Override
    public SkinTransform getTransform() {
        if (this.setBit(1)) {
            int flags = this.getInt(24);
            Vector3f translate = this.getVector3f(28);
            Vector3f rotation = this.getVector3f(40);
            Vector3f scale = this.getVector3f(52);
            Vector3f vector = this.getVector3f(64);
            Vector3f pivot = this.getVector3f(76);
            this.transform = SkinTransform.create(translate, rotation, scale, pivot, vector);
        }
        return this.transform;
    }

    @Override
    public IPaintColor getPaintColor(Direction dir) {
        ITextureKey key = this.getTexture(dir);
        if (key != null) {
            return PaintColor.WHITE;
        }
        return PaintColor.CLEAR;
    }

    @Override
    public ITextureKey getTexture(Direction dir) {
        if (this.setBit(2)) {
            this.parseTextures();
        }
        return this.textureKeys.get(dir);
    }

    @Override
    public SkinCubeFace getFace(Direction dir) {
        if (this.getTexture(dir) != null) {
            return super.getFace(dir);
        }
        return null;
    }

    protected void parseTextures() {
        this.startUVs.clear();
        this.endUVs.clear();
        this.optionsValues.clear();
        this.textureKeys.clear();
        TextureBox textureBox = null;
        int usedBytes = this.palette.getTextureIndexBytes();
        for (int i = 0; i < this.faceCount; ++i) {
            ChunkColorSection.TextureRef ref;
            int index = ChunkCubeDecoderV2.calcStride(usedBytes, i);
            byte face = this.getByte(index);
            if ((face & 0x40) != 0) {
                TextureOptions opt = ChunkColorSection.OptionsRef.readFromStream(usedBytes, this.readerIndex + index + 1, this.bytes);
                for (Direction dir : DirectionUtils.valuesFromSet(face)) {
                    this.optionsValues.put(dir, opt);
                }
                continue;
            }
            Vector2f pos = ChunkColorSection.TextureRef.readFromStream(usedBytes, this.readerIndex + index + 1, this.bytes);
            for (Direction dir : DirectionUtils.valuesFromSet(face)) {
                this.endUVs.put(dir, pos);
                if (this.startUVs.containsKey(dir)) continue;
                this.startUVs.put(dir, pos);
            }
            if ((face & 0x80) == 0 || (ref = this.palette.readTexture(pos)) == null) continue;
            Rectangle3f shape = this.getShape();
            float width = shape.getWidth();
            float height = shape.getHeight();
            float depth = shape.getDepth();
            textureBox = new TextureBox(width, height, depth, false, ref.getPos(), ref.getProvider());
        }
        for (Direction dir : Direction.values()) {
            Vector2f start = this.startUVs.get(dir);
            Vector2f end = this.endUVs.get(dir);
            if (start != null && end != null) {
                TextureOptions opt = this.optionsValues.get(dir);
                ChunkColorSection.TextureRef ref = this.palette.readTexture(start);
                if (ref == null) continue;
                float u = ref.getU();
                float v = ref.getV();
                float width = end.getX() - start.getX();
                float height = end.getY() - start.getY();
                this.textureKeys.put(dir, new TextureKey(u, v, width, height, opt, ref.getProvider()));
                continue;
            }
            if (textureBox == null) continue;
            this.textureKeys.put(dir, textureBox.getTexture(dir));
        }
    }

    @Override
    protected void reset() {
        this.flags.clear();
    }

    protected boolean setBit(int index) {
        if (this.flags.get(index)) {
            return false;
        }
        this.flags.set(index);
        return true;
    }
}

