/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.transformer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import moe.plushie.armourers_workshop.api.common.IResource;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;

public final class SkinSerializerV21 {
    public static Collection<IResource> getResourcesFromFile(File file) throws IOException {
        if (file.isDirectory()) {
            return SkinSerializerV21.getResourcesFromDirectory(file);
        }
        if (file.getName().toLowerCase().endsWith(".zip")) {
            return SkinSerializerV21.getResourcesFromZip(file);
        }
        return SkinSerializerV21.getResourcesFromSet(file);
    }

    public static Collection<IResource> getResourcesFromZip(File zipFile) throws IOException {
        ZipEntry entry;
        ArrayList<IResource> resources = new ArrayList<IResource>();
        final ZipFile file = new ZipFile(zipFile);
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));
        while ((entry = zip.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            final String fileName = entry.getName();
            final ZipEntry fileEntry = entry;
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public String getSource() {
                    return "";
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return file.getInputStream(fileEntry);
                }
            });
        }
        return resources;
    }

    public static Collection<IResource> getResourcesFromDirectory(File rootPath) throws IOException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (final File entry : SkinFileUtils.listAllFiles(rootPath)) {
            if (entry.isDirectory()) continue;
            final String fileName = SkinFileUtils.getRelativePath(entry, rootPath, true).substring(1);
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public String getSource() {
                    return "";
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(entry);
                }
            });
        }
        return resources;
    }

    public static Collection<IResource> getResourcesFromSet(File ... entries) throws IOException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (final File entry : entries) {
            if (entry.isDirectory()) continue;
            final String fileName = entry.getName();
            resources.add(new IResource(){

                @Override
                public String getName() {
                    return fileName;
                }

                @Override
                public String getSource() {
                    return "";
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(entry);
                }
            });
        }
        return resources;
    }
}

