/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ABI;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.jetbrains.annotations.Nullable;

public class PlayerTextureDescriptor {
    public static final PlayerTextureDescriptor EMPTY = new PlayerTextureDescriptor(Source.NONE, null, null);
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    private static final Cache<ItemStack, PlayerTextureDescriptor> DESCRIPTOR_CACHES = CacheBuilder.newBuilder().maximumSize(8L).expireAfterAccess(15L, TimeUnit.SECONDS).build();
    private Source source;
    private String value;
    private GameProfile profile;

    public PlayerTextureDescriptor(Source source, String value, GameProfile profile) {
        this.source = source;
        this.value = value;
        this.profile = profile;
    }

    public PlayerTextureDescriptor(@Nullable CompoundNBT nbt) {
        CompoundNBT tag;
        if (nbt != null && nbt.func_150297_b("URL", 8)) {
            this.source = Source.URL;
            this.value = nbt.func_74779_i("URL");
        }
        if (nbt != null && nbt.func_150297_b("User", 10) && (tag = nbt.func_74775_l("User")).func_150297_b("Name", 8)) {
            this.source = Source.USER;
            this.value = tag.func_74779_i("Name");
        }
        if (this.value == null && this.profile == null) {
            this.source = Source.NONE;
        }
    }

    public static PlayerTextureDescriptor of(ItemStack itemStack) {
        if (!ABI.is(itemStack, (Item)ModItems.MANNEQUIN.get())) {
            return EMPTY;
        }
        CompoundNBT entityTag = itemStack.func_179543_a("EntityTag");
        if (entityTag == null || !entityTag.func_150297_b("Texture", 10)) {
            return EMPTY;
        }
        PlayerTextureDescriptor descriptor = (PlayerTextureDescriptor)DESCRIPTOR_CACHES.getIfPresent((Object)itemStack);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = new PlayerTextureDescriptor(entityTag.func_74775_l("Texture"));
        DESCRIPTOR_CACHES.put((Object)itemStack, (Object)descriptor);
        return descriptor;
    }

    public static PlayerTextureDescriptor fromURL(String url) {
        return new PlayerTextureDescriptor(Source.URL, url, null);
    }

    public static PlayerTextureDescriptor fromName(String name) {
        return new PlayerTextureDescriptor(Source.USER, name, null);
    }

    public static PlayerTextureDescriptor fromProfile(GameProfile profile) {
        return new PlayerTextureDescriptor(Source.USER, profile.getName(), profile);
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        switch (this.source) {
            case URL: {
                if (this.value == null) break;
                nbt.func_74778_a("URL", this.value);
                break;
            }
            case USER: {
                if (this.value == null) break;
                CompoundNBT tag = new CompoundNBT();
                tag.func_74778_a("Name", this.value);
                nbt.func_218657_a("User", (INBT)tag);
                break;
            }
        }
        return nbt;
    }

    public boolean isEmpty() {
        return this.source == Source.NONE;
    }

    @Nullable
    public String getURL() {
        if (this.source == Source.URL) {
            return this.value;
        }
        return null;
    }

    @Nullable
    public String getName() {
        if (this.source == Source.USER && this.value != null) {
            return this.value;
        }
        return null;
    }

    @Nullable
    public GameProfile getProfile() {
        return this.profile;
    }

    public String getValue() {
        return this.value;
    }

    public Source getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerTextureDescriptor that = (PlayerTextureDescriptor)o;
        return this.source == that.source && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.value});
    }

    public static enum Source {
        NONE,
        USER,
        URL;

    }
}

