/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Objects;
import java.util.UUID;
import moe.plushie.armourers_workshop.compatibility.core.AbstractSavedData;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.storage.DimensionDataStorage.DataProvider;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;

public class ModContext
extends AbstractSavedData {
    private static ModContext current;
    private UUID t0;
    private UUID t1;
    private byte[] x0;
    private byte[] x1;

    public ModContext() {
        this.random();
        this.setDirty();
    }

    public static void init(MinecraftServer server) {
        current = DataProvider.computeIfAbsent(server.func_241755_D_().func_217481_x(), ModContext::new, 0, "ArmourersWorkshop");
    }

    public static void init(UUID t0, UUID t1) {
        current = new ModContext();
        current.apply(t0, t1);
    }

    public static void reset() {
        current = null;
    }

    public static UUID t0() {
        if (current != null) {
            return ModContext.current.t0;
        }
        return null;
    }

    public static UUID t1() {
        if (current != null) {
            return ModContext.current.t1;
        }
        return null;
    }

    public static UUID t2(UUID p) {
        return ModContext.md5(Objects.requireNonNull(ModContext.t0()), p);
    }

    public static UUID t3(UUID p) {
        return ModContext.md5(Objects.requireNonNull(ModContext.t1()), p);
    }

    public static byte[] x0() {
        if (current != null) {
            return ModContext.current.x0;
        }
        return null;
    }

    public static byte[] x1() {
        if (current != null) {
            return ModContext.current.x1;
        }
        return null;
    }

    public static String md5(String value) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] sig = md.digest(value.getBytes(StandardCharsets.UTF_8));
            return new String(Hex.encodeHex((byte[])sig, (boolean)true));
        }
        catch (Exception e) {
            e.printStackTrace();
            return value;
        }
    }

    @NotNull
    private static UUID md5(UUID v1, UUID v2) {
        int v0 = 20220616;
        ByteBuffer buffer0 = ByteBuffer.allocate(64);
        buffer0.putLong(v0 + -527525385);
        buffer0.putLong(v1.getLeastSignificantBits());
        buffer0.putLong(v0 + -1629023019);
        buffer0.putLong(v2.getMostSignificantBits());
        buffer0.putLong(v0 + 1022817964);
        buffer0.putLong(v1.getLeastSignificantBits());
        buffer0.putLong(v0 + 1821159228);
        buffer0.putLong(v2.getLeastSignificantBits());
        return UUID.nameUUIDFromBytes(buffer0.array());
    }

    private void apply(UUID t0, UUID t1) {
        ModLog.debug("apply context", new Object[0]);
        this.t0 = t0;
        this.t1 = t1;
        this.x0 = null;
        this.x1 = null;
        if (t0 == null || t1 == null) {
            return;
        }
        try {
            int v0 = 20220616;
            MessageDigest md = MessageDigest.getInstance("MD5");
            ByteBuffer buffer0 = ByteBuffer.allocate(64);
            ByteBuffer buffer1 = ByteBuffer.allocate(192);
            buffer0.putLong(v0 + -527525385);
            buffer0.putLong(t0.getLeastSignificantBits());
            buffer0.putLong(v0 + -1629023019);
            buffer0.putLong(t0.getMostSignificantBits());
            buffer0.putLong(v0 + 1022817964);
            buffer0.putLong(t1.getLeastSignificantBits());
            buffer0.putLong(v0 + 1821159228);
            this.x0 = md.digest(buffer0.array());
            buffer1.putLong(v0 + -527525383);
            buffer1.putLong(t1.getMostSignificantBits());
            buffer1.putLong(t0.getLeastSignificantBits());
            buffer1.putLong(v0 + -1629023019);
            buffer1.put(this.x0);
            buffer1.putLong(v0 + 1022817964);
            buffer1.putLong(t1.getLeastSignificantBits());
            buffer1.putLong(t0.getMostSignificantBits());
            buffer1.putLong(v0 + 1821159228);
            this.x1 = md.digest(buffer1.array());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void random() {
        this.t0 = UUID.randomUUID();
        this.t1 = UUID.randomUUID();
    }

    @Override
    public void load(CompoundNBT tag) {
        int count = 0;
        if (tag.func_186855_b("t0")) {
            this.t0 = tag.func_186857_a("t0");
            ++count;
        }
        if (tag.func_186855_b("t1")) {
            this.t1 = tag.func_186857_a("t1");
            ++count;
        }
        if (count != 2) {
            this.random();
            this.setDirty();
        }
        this.apply(this.t0, this.t1);
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt.func_186854_a("t0", this.t0);
        nbt.func_186854_a("t1", this.t1);
        return nbt;
    }
}

