/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.core.holiday.ChristmasSeasonHandler;
import moe.plushie.armourers_workshop.core.holiday.HalloweenSeasonHandler;
import moe.plushie.armourers_workshop.core.holiday.Holiday;
import moe.plushie.armourers_workshop.core.holiday.HolidayTracker;
import moe.plushie.armourers_workshop.core.holiday.ValentinesHandler;
import moe.plushie.armourers_workshop.core.item.GiftSackItem;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public final class ModHolidays {
    private static final ArrayList<Holiday> HOLIDAY_LIST = new ArrayList();
    public static final Holiday HALLOWEEN = ModHolidays.register("halloween", 31, 9, 1, 0, null);
    public static final Holiday HALLOWEEN_SEASON = ModHolidays.register("halloween-season", 24, 9, 8, 0, HalloweenSeasonHandler::new);
    public static final Holiday CHRISTMAS = ModHolidays.register("christmas", 25, 11, 0, 24, null);
    public static final Holiday CHRISTMAS_SEASON = ModHolidays.register("christmas-season", 1, 11, 31, 0, ChristmasSeasonHandler::new);
    public static final Holiday VALENTINES = ModHolidays.register("valentines", 14, 1, 1, 0, ValentinesHandler::new);
    public static final Holiday NEW_YEARS = ModHolidays.register("new-years", 1, 0, 1, 0, null);
    public static final Holiday PONYTAIL_DAY = ModHolidays.register("ponytail-day", 7, 6, 1, 0, null);
    public static final Holiday APRIL_FOOLS = ModHolidays.register("april-fools", 1, 3, 1, 0, null);

    public static void init() {
    }

    public static Collection<Holiday> getHolidays() {
        return HOLIDAY_LIST;
    }

    public static Collection<Holiday> getActiveHolidays() {
        return ObjectUtils.filter(HOLIDAY_LIST, Holiday::isHolidayActive);
    }

    @Nullable
    public static Holiday byName(String name) {
        for (Holiday holiday : HOLIDAY_LIST) {
            if (!holiday.getName().equals(name)) continue;
            return holiday;
        }
        return null;
    }

    public static void welcome(PlayerEntity player) {
        MinecraftServer server = player.func_184102_h();
        if (server == null || ModConfig.Common.disableAllHolidayEvents) {
            return;
        }
        for (Holiday holiday1 : ModHolidays.getActiveHolidays()) {
            HolidayTracker storage;
            if (holiday1.getHandler() == null || (storage = HolidayTracker.of(server)).has(player, holiday1)) continue;
            ItemStack itemStack = GiftSackItem.of(holiday1);
            if (PropertyProvider.getInventory(player).func_70441_a(itemStack)) {
                storage.add(player, holiday1);
                continue;
            }
            SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.inventoryGiftFail", new Object[0]));
        }
    }

    public static int getYear() {
        return Calendar.getInstance().get(1);
    }

    private static Holiday register(String name, int dayOfMonth, int month, int lengthInDays, int lengthInHours, @Nullable Supplier<Holiday.IHandler> builder) {
        Calendar startDate = Calendar.getInstance();
        startDate.set(12, 0);
        startDate.set(11, 0);
        startDate.set(2, month);
        startDate.set(5, dayOfMonth);
        Calendar endDate = (Calendar)startDate.clone();
        endDate.add(6, lengthInDays);
        endDate.add(11, lengthInHours);
        Holiday holiday = new Holiday(name, startDate, endDate);
        if (builder != null) {
            holiday.setHandler(builder.get());
        }
        ModLog.debug("Registering Holiday '{}:{}'", "armourers_workshop", name);
        HOLIDAY_LIST.add(holiday);
        return holiday;
    }
}

