/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IItemGroup;
import moe.plushie.armourers_workshop.api.registry.IItemBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.builder.client.render.SkinCubeItemRenderer;
import moe.plushie.armourers_workshop.builder.item.BlendingToolItem;
import moe.plushie.armourers_workshop.builder.item.BlockMarkerItem;
import moe.plushie.armourers_workshop.builder.item.BurnToolItem;
import moe.plushie.armourers_workshop.builder.item.ColorNoiseToolItem;
import moe.plushie.armourers_workshop.builder.item.ColorPickerItem;
import moe.plushie.armourers_workshop.builder.item.DodgeToolItem;
import moe.plushie.armourers_workshop.builder.item.HueToolItem;
import moe.plushie.armourers_workshop.builder.item.PaintRollerItem;
import moe.plushie.armourers_workshop.builder.item.PaintbrushItem;
import moe.plushie.armourers_workshop.builder.item.ShadeNoiseToolItem;
import moe.plushie.armourers_workshop.builder.item.SkinCubeItem;
import moe.plushie.armourers_workshop.builder.item.SoapItem;
import moe.plushie.armourers_workshop.core.client.render.MannequinItemRenderer;
import moe.plushie.armourers_workshop.core.client.render.SkinItemRenderer;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.item.ArmourersHammerItem;
import moe.plushie.armourers_workshop.core.item.BottleItem;
import moe.plushie.armourers_workshop.core.item.FlavouredItem;
import moe.plushie.armourers_workshop.core.item.GiftSackItem;
import moe.plushie.armourers_workshop.core.item.LinkingToolItem;
import moe.plushie.armourers_workshop.core.item.MannequinItem;
import moe.plushie.armourers_workshop.core.item.MannequinToolItem;
import moe.plushie.armourers_workshop.core.item.SkinItem;
import moe.plushie.armourers_workshop.core.item.SkinUnlockItem;
import moe.plushie.armourers_workshop.core.item.WandOfStyleItem;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.init.ModItemGroups;
import moe.plushie.armourers_workshop.init.platform.BuilderManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;

public class ModItems {
    private static final ItemBuilder MAIN = new ItemBuilder(ModItemGroups.MAIN_GROUP);
    private static final ItemBuilder BUILDING = new ItemBuilder(ModItemGroups.BUILDING_GROUP);
    private static final ItemBuilder NONE = new ItemBuilder(null);
    public static final IRegistryKey<Item> SKIN = (IRegistryKey)NONE.skin(ModBlocks.SKINNABLE).bind(() -> SkinItemRenderer::getInstance).build("skin");
    public static final IRegistryKey<Item> MANNEQUIN = (IRegistryKey)MAIN.normal(MannequinItem::new).rarity(Rarity.RARE).bind(() -> MannequinItemRenderer::getInstance).build("mannequin");
    public static final IRegistryKey<Item> SKIN_LIBRARY = (IRegistryKey)MAIN.block(ModBlocks.SKIN_LIBRARY).build("skin-library");
    public static final IRegistryKey<Item> SKIN_LIBRARY_CREATIVE = (IRegistryKey)MAIN.block(ModBlocks.SKIN_LIBRARY_CREATIVE).rarity(Rarity.EPIC).build("skin-library-creative");
    public static final IRegistryKey<Item> SKIN_LIBRARY_GLOBAL = (IRegistryKey)MAIN.block(ModBlocks.SKIN_LIBRARY_GLOBAL).build("skin-library-global");
    public static final IRegistryKey<Item> SKINNING_TABLE = (IRegistryKey)MAIN.block(ModBlocks.SKINNING_TABLE).build("skinning-table");
    public static final IRegistryKey<Item> DYE_TABLE = (IRegistryKey)MAIN.block(ModBlocks.DYE_TABLE).build("dye-table");
    public static final IRegistryKey<Item> OUTFIT_MAKER = (IRegistryKey)MAIN.block(ModBlocks.OUTFIT_MAKER).build("outfit-maker");
    public static final IRegistryKey<Item> HOLOGRAM_PROJECTOR = (IRegistryKey)MAIN.block(ModBlocks.HOLOGRAM_PROJECTOR).build("hologram-projector");
    public static final IRegistryKey<Item> BOTTLE = (IRegistryKey)MAIN.normal(BottleItem::new).stacksTo(64).build("dye-bottle");
    public static final IRegistryKey<Item> MANNEQUIN_TOOL = (IRegistryKey)MAIN.normal(MannequinToolItem::new).build("mannequin-tool");
    public static final IRegistryKey<Item> ARMOURERS_HAMMER = (IRegistryKey)MAIN.normal(ArmourersHammerItem::new).build("armourers-hammer");
    public static final IRegistryKey<Item> WAND_OF_STYLE = (IRegistryKey)MAIN.normal(WandOfStyleItem::new).build("wand-of-style");
    public static final IRegistryKey<Item> SKIN_UNLOCK_HEAD = (IRegistryKey)MAIN.unlock(SkinSlotType.HEAD).build("skin-unlock-head");
    public static final IRegistryKey<Item> SKIN_UNLOCK_CHEST = (IRegistryKey)MAIN.unlock(SkinSlotType.CHEST).build("skin-unlock-chest");
    public static final IRegistryKey<Item> SKIN_UNLOCK_FEET = (IRegistryKey)MAIN.unlock(SkinSlotType.FEET).build("skin-unlock-feet");
    public static final IRegistryKey<Item> SKIN_UNLOCK_LEGS = (IRegistryKey)MAIN.unlock(SkinSlotType.LEGS).build("skin-unlock-legs");
    public static final IRegistryKey<Item> SKIN_UNLOCK_WINGS = (IRegistryKey)MAIN.unlock(SkinSlotType.WINGS).build("skin-unlock-wings");
    public static final IRegistryKey<Item> SKIN_UNLOCK_OUTFIT = (IRegistryKey)MAIN.unlock(SkinSlotType.OUTFIT).build("skin-unlock-outfit");
    public static final IRegistryKey<Item> LINKING_TOOL = (IRegistryKey)MAIN.normal(LinkingToolItem::new).build("linking-tool");
    public static final IRegistryKey<Item> SKIN_TEMPLATE = (IRegistryKey)MAIN.normal(FlavouredItem::new).stacksTo(64).build("skin-template");
    public static final IRegistryKey<Item> SOAP = (IRegistryKey)MAIN.normal(SoapItem::new).stacksTo(64).build("soap");
    public static final IRegistryKey<Item> GIFT_SACK = (IRegistryKey)MAIN.normal(GiftSackItem::new).stacksTo(64).build("gift-sack");
    public static final IRegistryKey<Item> ARMOURER = (IRegistryKey)BUILDING.block(ModBlocks.ARMOURER).rarity(Rarity.EPIC).build("armourer");
    public static final IRegistryKey<Item> COLOR_MIXER = (IRegistryKey)BUILDING.block(ModBlocks.COLOR_MIXER).build("colour-mixer");
    public static final IRegistryKey<Item> ADVANCED_SKIN_BUILDER = (IRegistryKey)BUILDING.block(ModBlocks.ADVANCED_SKIN_BUILDER).build("advanced-skin-builder");
    public static final IRegistryKey<Item> SKIN_CUBE = (IRegistryKey)BUILDING.cube(ModBlocks.SKIN_CUBE).build("skin-cube");
    public static final IRegistryKey<Item> SKIN_CUBE_GLOWING = (IRegistryKey)BUILDING.cube(ModBlocks.SKIN_CUBE_GLOWING).build("skin-cube-glowing");
    public static final IRegistryKey<Item> SKIN_CUBE_GLASS = (IRegistryKey)BUILDING.cube(ModBlocks.SKIN_CUBE_GLASS).build("skin-cube-glass");
    public static final IRegistryKey<Item> SKIN_CUBE_GLASS_GLOWING = (IRegistryKey)BUILDING.cube(ModBlocks.SKIN_CUBE_GLASS_GLOWING).build("skin-cube-glass-glowing");
    public static final IRegistryKey<Item> PAINT_BRUSH = (IRegistryKey)BUILDING.normal(PaintbrushItem::new).build("paintbrush");
    public static final IRegistryKey<Item> PAINT_ROLLER = (IRegistryKey)BUILDING.normal(PaintRollerItem::new).build("paint-roller");
    public static final IRegistryKey<Item> BURN_TOOL = (IRegistryKey)BUILDING.normal(BurnToolItem::new).build("burn-tool");
    public static final IRegistryKey<Item> DODGE_TOOL = (IRegistryKey)BUILDING.normal(DodgeToolItem::new).build("dodge-tool");
    public static final IRegistryKey<Item> SHADE_NOISE_TOOL = (IRegistryKey)BUILDING.normal(ShadeNoiseToolItem::new).build("shade-noise-tool");
    public static final IRegistryKey<Item> COLOR_NOISE_TOOL = (IRegistryKey)BUILDING.normal(ColorNoiseToolItem::new).build("colour-noise-tool");
    public static final IRegistryKey<Item> BLENDING_TOOL = (IRegistryKey)BUILDING.normal(BlendingToolItem::new).build("blending-tool");
    public static final IRegistryKey<Item> HUE_TOOL = (IRegistryKey)BUILDING.normal(HueToolItem::new).build("hue-tool");
    public static final IRegistryKey<Item> COLOR_PICKER = (IRegistryKey)BUILDING.normal(ColorPickerItem::new).build("colour-picker");
    public static final IRegistryKey<Item> BLOCK_MARKER = (IRegistryKey)BUILDING.normal(BlockMarkerItem::new).build("block-marker");

    public static void init() {
    }

    private static class ItemBuilder {
        IRegistryKey<IItemGroup> group;

        ItemBuilder(IRegistryKey<IItemGroup> group) {
            this.group = group;
        }

        IItemBuilder<Item> normal(Function<Item.Properties, Item> factory) {
            return this._create(factory).stacksTo(1).group(this.group);
        }

        IItemBuilder<Item> block(IRegistryKey<Block> block) {
            return this._create(BlockItem::new, block).stacksTo(64).rarity(Rarity.RARE);
        }

        IItemBuilder<Item> cube(IRegistryKey<Block> block) {
            return this._create(SkinCubeItem::new, block).stacksTo(64).bind(() -> SkinCubeItemRenderer::getInstance);
        }

        IItemBuilder<Item> skin(IRegistryKey<Block> block) {
            return this._create(SkinItem::new, block).stacksTo(1);
        }

        IItemBuilder<Item> unlock(SkinSlotType slotType) {
            return this._create(SkinUnlockItem::new, () -> slotType).stacksTo(16).rarity(Rarity.UNCOMMON);
        }

        private IItemBuilder<Item> _create(Function<Item.Properties, Item> factory) {
            return (IItemBuilder)ObjectUtils.unsafeCast(BuilderManager.getInstance().createItemBuilder(factory));
        }

        private <T> IItemBuilder<Item> _create(BiFunction<T, Item.Properties, Item> factory, Supplier<T> supplier) {
            return this._create(properties -> (Item)factory.apply(supplier.get(), (Item.Properties)properties)).group(this.group);
        }
    }
}

