/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import moe.plushie.armourers_workshop.api.common.IArgumentSerializer;
import moe.plushie.armourers_workshop.api.common.IArgumentType;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.core.data.color.ColorScheme;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.init.command.ColorSchemeParser;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import net.minecraft.command.CommandSource;
import net.minecraft.network.PacketBuffer;

public class ColorSchemeArgumentType
implements IArgumentType<ColorScheme> {
    private static final Collection<String> EXAMPLES = ObjectUtils.map("<dyeIndex=[paintType:]#RRGGBB>", "<dyeIndex=[paintType:]R,G,B>");

    public static ColorScheme getColorScheme(CommandContext<CommandSource> context, String name) {
        return (ColorScheme)context.getArgument(name, ColorScheme.class);
    }

    public ColorScheme parse(StringReader reader) throws CommandSyntaxException {
        ColorSchemeParser parser = new ColorSchemeParser(reader).parse();
        ColorScheme colorScheme = new ColorScheme();
        for (Map.Entry<ISkinPaintType, PaintColor> entry : parser.getProperties().entrySet()) {
            colorScheme.setColor(entry.getKey(), entry.getValue());
        }
        return colorScheme;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        ColorSchemeParser parser = new ColorSchemeParser(stringReader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return parser.fillSuggestions(builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Serializer
    implements IArgumentSerializer<ColorSchemeArgumentType> {
        @Override
        public void serializeToNetwork(ColorSchemeArgumentType argument, PacketBuffer buffer) {
        }

        @Override
        public ColorSchemeArgumentType deserializeFromNetwork(PacketBuffer buffer) {
            return new ColorSchemeArgumentType();
        }

        @Override
        public void serializeToJson(ColorSchemeArgumentType argument, JsonObject json) {
        }
    }
}

