/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.File;
import moe.plushie.armourers_workshop.api.config.IConfigSpec;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.forge.EnvironmentManagerImpl;
import moe.plushie.armourers_workshop.utils.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EnvironmentManager {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getVersion() {
        return EnvironmentManagerImpl.getVersion();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static EnvironmentType getEnvironmentType() {
        return EnvironmentManagerImpl.getEnvironmentType();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static File getRootDirectory() {
        return EnvironmentManagerImpl.getRootDirectory();
    }

    public static File getSkinLibraryDirectory() {
        return new File(EnvironmentManager.getRootDirectory(), "skin-library");
    }

    public static File getSkinCacheDirectory() {
        return new File(EnvironmentManager.getRootDirectory(), "skin-cache");
    }

    public static File getSkinDatabaseDirectory() {
        return EnvironmentManager.getServer().func_240776_a_(Constants.Folder.LOCAL_DB).toFile();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MinecraftServer getServer() {
        return EnvironmentManagerImpl.getServer();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static PlayerEntity getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static boolean isDedicatedServer() {
        return EnvironmentManager.getEnvironmentType() == EnvironmentType.SERVER;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDevelopment() {
        return EnvironmentManagerImpl.isDevelopment();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isInstalled(String modId) {
        return EnvironmentManagerImpl.isInstalled(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IConfigSpec getClientConfigSpec() {
        return EnvironmentManagerImpl.getClientConfigSpec();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IConfigSpec getCommonConfigSpec() {
        return EnvironmentManagerImpl.getCommonConfigSpec();
    }
}

