/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.IResultHandler;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IPacketDistributor;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.network.CustomReplyPacket;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.forge.NetworkManagerImpl;
import moe.plushie.armourers_workshop.utils.PacketSplitter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NetworkManager {
    private static Dispatcher dispatcher;
    private static Distributors distributors;

    public static void init(String name, String version) {
        dispatcher = NetworkManager.createDispatcher(ModConstants.key(name), version);
        distributors = NetworkManager.createDistributors();
        dispatcher.register();
    }

    public static void sendToTrackingBlock(CustomPacket message, TileEntity blockEntity) {
        World level = blockEntity.func_145831_w();
        if (level == null) {
            return;
        }
        Chunk chunk = level.func_175726_f(blockEntity.func_174877_v());
        dispatcher.split(message, distributors.trackingChunk(() -> chunk));
    }

    public static void sendToTracking(CustomPacket message, Entity entity) {
        dispatcher.split(message, distributors.trackingEntityAndSelf(() -> entity));
    }

    public static void sendTo(CustomPacket message, ServerPlayerEntity player) {
        dispatcher.split(message, distributors.player(() -> player));
    }

    public static void sendToServer(CustomPacket message) {
        dispatcher.split(message, distributors.server());
    }

    public static void sendToAll(CustomPacket message) {
        dispatcher.split(message, distributors.allPlayers());
    }

    public static void sendWardrobeTo(Entity entity, ServerPlayerEntity player) {
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null) {
            wardrobe.broadcast(player);
        }
    }

    public static <R> void sendTo(CustomReplyPacket<R> message, ServerPlayerEntity player, IResultHandler<R> handler) {
        CustomReplyPacket.Receiver.await(message, handler);
        NetworkManager.sendTo(message, player);
    }

    public static <R> void sendToServer(CustomReplyPacket<R> message, IResultHandler<R> handler) {
        CustomReplyPacket.Receiver.await(message, handler);
        NetworkManager.sendToServer(message);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Dispatcher createDispatcher(ResourceLocation registryName, String version) {
        void var1_1;
        return NetworkManagerImpl.createDispatcher(registryName, (String)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Distributors createDistributors() {
        return NetworkManagerImpl.createDistributors();
    }

    public static abstract class Dispatcher {
        protected final UUID clientUUID = UUID.randomUUID();
        protected final String channelVersion;
        protected final ResourceLocation channelName;
        protected final PacketSplitter splitter;
        protected final int maxPartSize = 32000;

        public Dispatcher(ResourceLocation channelName, String channelVersion) {
            this.channelName = channelName;
            this.channelVersion = channelVersion;
            this.splitter = new PacketSplitter();
        }

        public abstract void register();

        public void didReceivePacket(IServerPacketHandler packetHandler, PacketBuffer payload, ServerPlayerEntity player) {
            this.merge(player.func_110124_au(), payload, packet -> packetHandler.enqueueWork(() -> packet.accept(packetHandler, player)));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void didReceivePacket(IClientPacketHandler packetHandler, PacketBuffer payload, PlayerEntity player) {
            this.merge(this.clientUUID, payload, packet -> packetHandler.enqueueWork(() -> packet.accept(packetHandler, EnvironmentManager.getPlayer())));
        }

        public void merge(UUID uuid, PacketBuffer buffer, Consumer<CustomPacket> consumer) {
            this.splitter.merge(uuid, buffer, consumer);
        }

        public void split(CustomPacket message, IPacketDistributor distributor) {
            int partSize = 32000;
            if (distributor.isClientbound()) {
                partSize = Integer.MAX_VALUE;
            }
            this.splitter.split(message, buf -> distributor.add(this.channelName, (PacketBuffer)buf), partSize, IPacketDistributor::execute);
        }
    }

    public static interface Distributors {
        public IPacketDistributor trackingChunk(Supplier<Chunk> var1);

        public IPacketDistributor trackingEntityAndSelf(Supplier<Entity> var1);

        public IPacketDistributor player(Supplier<ServerPlayerEntity> var1);

        public IPacketDistributor allPlayers();

        public IPacketDistributor server();
    }
}

