/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.client.key.IKeyBinding;
import moe.plushie.armourers_workshop.api.client.key.IKeyModifier;
import moe.plushie.armourers_workshop.api.registry.IKeyBindingBuilder;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeKeyMapping;
import moe.plushie.armourers_workshop.init.platform.ClientNativeManager;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.ext.OpenKeyModifier;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class KeyBindingBuilderImpl<T extends IKeyBinding>
implements IKeyBindingBuilder<T> {
    private static final ArrayList<Pair<KeyBinding, Supplier<Runnable>>> INPUTS = KeyBindingBuilderImpl.createAndAttach();
    private final String key;
    private IKeyModifier modifier = OpenKeyModifier.NONE;
    private String category = "";
    private Supplier<Runnable> handler;

    public KeyBindingBuilderImpl(String key) {
        this.key = key;
    }

    @Override
    public IKeyBindingBuilder<T> modifier(IKeyModifier modifier) {
        this.modifier = modifier;
        return this;
    }

    @Override
    public IKeyBindingBuilder<T> category(String category) {
        this.category = category;
        return this;
    }

    @Override
    public IKeyBindingBuilder<T> bind(Supplier<Runnable> handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public T build(String name) {
        String nameKey = "keys.armourers_workshop." + name;
        String categoryKey = "keys.armourers_workshop." + this.category;
        InputMappings.Input input = InputMappings.func_197955_a((String)this.key);
        final OnceKeyBinding binding = KeyBindingBuilderImpl.createKeyBinding(nameKey, this.modifier, input, categoryKey);
        if (this.handler != null) {
            INPUTS.add((Pair<KeyBinding, Supplier<Runnable>>)Pair.of((Object)((Object)binding), this.handler));
        }
        ClientNativeManager.getProvider().willRegisterKeyMapping(registry -> registry.register(binding));
        IKeyBinding binding1 = new IKeyBinding(){

            @Override
            public ITextComponent getKeyName() {
                return binding.func_238171_j_();
            }

            @Override
            public IKeyModifier getKeyModifier() {
                return binding.getOpenKeyModifier();
            }
        };
        return (T)((IKeyBinding)ObjectUtils.unsafeCast(binding1));
    }

    private static OnceKeyBinding createKeyBinding(String description, IKeyModifier keyModifier, InputMappings.Input keyCode, String category) {
        return new OnceKeyBinding(description, keyModifier, keyCode, category);
    }

    private static <T> ArrayList<T> createAndAttach() {
        ClientNativeManager.getProvider().willInput(ignored -> INPUTS.forEach((Consumer<Pair<KeyBinding, Supplier<Runnable>>>)((Consumer<Pair>)pair -> {
            if (((KeyBinding)pair.getKey()).func_151468_f()) {
                ((Runnable)((Supplier)pair.getValue()).get()).run();
            }
        })));
        return new ArrayList();
    }

    public static class OnceKeyBinding
    extends AbstractForgeKeyMapping {
        private boolean canConsumeClick = true;

        public OnceKeyBinding(String description, IKeyModifier keyModifier, InputMappings.Input keyCode, String category) {
            super(description, keyModifier, keyCode, category);
        }

        public boolean func_151468_f() {
            if (this.canConsumeClick && this.func_151470_d()) {
                this.canConsumeClick = false;
                return true;
            }
            return false;
        }

        public void func_225593_a_(boolean isDown) {
            super.func_225593_a_(isDown);
            if (!isDown) {
                this.canConsumeClick = true;
            }
        }
    }
}

