/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform.forge.builder;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.common.ILootFunction;
import moe.plushie.armourers_workshop.api.common.ILootFunctionType;
import moe.plushie.armourers_workshop.api.registry.ILootFunctionBuilder;
import moe.plushie.armourers_workshop.api.registry.IRegistryKey;
import moe.plushie.armourers_workshop.compatibility.core.AbstractLootItemFunction;
import moe.plushie.armourers_workshop.compatibility.forge.AbstractForgeRegistries;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.TypedRegistry;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.util.ResourceLocation;

public class LootFunctionBuilderImpl<T extends ILootFunction>
implements ILootFunctionBuilder<T> {
    private final Codec<? extends T> codec;

    public LootFunctionBuilderImpl(Codec<? extends T> codec) {
        this.codec = codec;
    }

    @Override
    public IRegistryKey<ILootFunctionType<T>> build(String name) {
        LootFunctionType[] type = new LootFunctionType[]{null};
        ResourceLocation registryName = ModConstants.key(name);
        type[0] = this.createType(() -> type[0]);
        Proxy proxy = new Proxy(type[0]);
        AbstractForgeRegistries.ITEM_LOOT_FUNCTIONS.register(name, () -> type[0]);
        return TypedRegistry.Entry.of(registryName, () -> proxy);
    }

    public LootFunctionType createType(Supplier<LootFunctionType> type) {
        return new LootFunctionType(AbstractLootItemFunction.conditional(type, this.codec));
    }

    public static class Proxy<T extends ILootFunction>
    implements ILootFunctionType<T> {
        private final LootFunctionType type;

        public Proxy(LootFunctionType type) {
            this.type = type;
        }
    }
}

