/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.proxy;

import java.util.stream.Stream;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.IBlockTintColorProvider;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.common.IResourceManager;
import moe.plushie.armourers_workshop.core.client.bake.SkinBakery;
import moe.plushie.armourers_workshop.core.client.bake.SkinPreloadManager;
import moe.plushie.armourers_workshop.core.client.other.SkinTextureManager;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRendererManager2;
import moe.plushie.armourers_workshop.core.data.DataPackLoader;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.data.ticket.Tickets;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModContext;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModKeyBindings;
import moe.plushie.armourers_workshop.init.client.ClientWardrobeHandler;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.environment.EnvironmentType;
import moe.plushie.armourers_workshop.init.platform.ClientNativeManager;
import moe.plushie.armourers_workshop.init.platform.DataPackManager;
import moe.plushie.armourers_workshop.init.platform.ItemTooltipManager;
import moe.plushie.armourers_workshop.init.provider.ClientNativeProvider;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.library.data.impl.MinecraftAuth;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.TickUtils;
import moe.plushie.armourers_workshop.utils.TypedRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy {
    public static void init() {
        MinecraftAuth.init(() -> Minecraft.func_71410_x().func_110432_I().func_148255_b(), () -> Minecraft.func_71410_x().func_110432_I().func_148254_d());
        ClientWardrobeHandler.init();
        SkinRendererManager2.init();
        ModKeyBindings.init();
        ModDebugger.init();
        EnvironmentExecutor.willSetup(EnvironmentType.CLIENT, () -> () -> {
            net.minecraft.resources.IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
            DataPackLoader packLoader = DataPackManager.byType(DataPackType.CLIENT_RESOURCES);
            ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)packLoader);
        });
        ClientProxy.register(ClientNativeManager.getProvider());
    }

    private static void register(ClientNativeProvider registries) {
        registries.willRegisterItemColor(registry -> TypedRegistry.findEntries(Item.class).forEach(it -> {
            Item item = (Item)it.get();
            if (item instanceof IItemTintColorProvider) {
                registry.register((IItemTintColorProvider)item, item);
            }
        }));
        registries.willRegisterItemProperty(registry -> TypedRegistry.findEntries(Item.class).forEach(it -> {
            Item item = (Item)it.get();
            IItemPropertiesProvider provider = ObjectUtils.safeCast(item, IItemPropertiesProvider.class);
            if (provider != null) {
                provider.createModelProperties((key, property) -> registry.register((ResourceLocation)key, item, (IItemModelProperty)property));
            }
            registry.register(ModConstants.key("type"), Items.field_222114_py, (itemStack, level, entity, id) -> 1.0f);
        }));
        registries.willRegisterBlockColor(registry -> TypedRegistry.findEntries(Block.class).forEach(it -> {
            Block block = (Block)it.get();
            if (block instanceof IBlockTintColorProvider) {
                registry.register((IBlockTintColorProvider)block, block);
            }
        }));
        registries.willRegisterModel(registry -> SkinPartTypes.registeredTypes().forEach(partType -> {
            ModelResourceLocation rl = ArmourersWorkshop.getCustomModel(partType.getRegistryName());
            IResourceManager resourceManager = ClientNativeManager.getResourceManager();
            if (resourceManager.hasResource(new ResourceLocation(rl.func_110624_b(), "models/item/" + rl.func_110623_a() + ".json"))) {
                registry.register((ResourceLocation)rl);
            }
        }));
        registries.willRegisterTexture(registry -> Stream.of(SkinSlotType.values()).forEach(slotType -> registry.register(slotType.getIconSprite())));
        registries.willPlayerLogin(player -> {
            SkinBakery.start();
            SkinPreloadManager.start();
            SkinTextureManager.getInstance().start();
        });
        registries.willPlayerLogout(player -> {
            SkinPreloadManager.stop();
            SkinBakery.stop();
            Tickets.invalidateAll();
            SkinTextureManager.getInstance().stop();
            SkinLoader.getInstance().stop();
            SkinLibraryManager.getClient().getPublicSkinLibrary().reset();
            SkinLibraryManager.getClient().getPrivateSkinLibrary().reset();
            ModContext.reset();
            ModConfigSpec.COMMON.apply(null);
        });
        registries.willTick(isPaused -> {
            TickUtils.tick(isPaused);
            SkinPreloadManager.tick(isPaused);
        });
        registries.willGatherTooltip(ItemTooltipManager::gatherSkinTooltip);
        registries.willRenderTooltip(ItemTooltipManager::renderSkinTooltip);
    }
}

