/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.data;

import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public class SkinLibrarySetting {
    public static final SkinLibrarySetting DEFAULT = new SkinLibrarySetting();
    private final int flags;

    public SkinLibrarySetting() {
        this.flags = 15;
    }

    public SkinLibrarySetting(PlayerEntity player) {
        int flags = 0;
        SkinLibraryManager.Server manager = SkinLibraryManager.getServer();
        if (((SkinLibraryManager)manager).shouldUploadFile(player)) {
            flags |= 1;
        }
        if (((SkinLibraryManager)manager).shouldDownloadFile(player)) {
            flags |= 2;
        }
        if (((SkinLibraryManager)manager).shouldMaintenanceFile(player)) {
            flags |= 4;
        }
        this.flags = flags;
    }

    public SkinLibrarySetting(CompoundNBT tag) {
        this.flags = OptionalAPI.getOptionalInt(tag, "Flags", 0);
    }

    public boolean allowsUpload() {
        return (this.flags & 1) != 0;
    }

    public boolean allowsDownload() {
        return (this.flags & 2) != 0;
    }

    public boolean allowsMaintenance() {
        return (this.flags & 4) != 0;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        OptionalAPI.putOptionalInt(tag, "Flags", this.flags, 0);
        return tag;
    }
}

