/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.library.network;

import com.google.common.collect.Iterables;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.library.data.SkinLibraryFile;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import moe.plushie.armourers_workshop.library.data.SkinLibrarySetting;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class UpdateLibraryFilesPacket
extends CustomPacket {
    private final ArrayList<SkinLibraryFile> publicFiles;
    private final ArrayList<SkinLibraryFile> privateFiles;
    private final SkinLibrarySetting setting;

    public UpdateLibraryFilesPacket(ArrayList<SkinLibraryFile> publicFiles, ArrayList<SkinLibraryFile> privateFiles, SkinLibrarySetting setting) {
        this.setting = setting;
        this.publicFiles = publicFiles;
        this.privateFiles = privateFiles;
    }

    public UpdateLibraryFilesPacket(PacketBuffer buffer) {
        this.setting = new SkinLibrarySetting(buffer.func_150793_b());
        this.publicFiles = new ArrayList();
        this.privateFiles = new ArrayList();
        for (SkinLibraryFile file : this.readCompressedBuffer(new ByteBufInputStream((ByteBuf)buffer))) {
            if (file.getPath().startsWith("/private")) {
                this.privateFiles.add(file);
                continue;
            }
            this.publicFiles.add(file);
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        int totalSize = this.publicFiles.size() + this.privateFiles.size();
        buffer.func_150786_a(this.setting.serializeNBT());
        this.writeCompressedBuffer(new ByteBufOutputStream((ByteBuf)buffer), Iterables.concat(this.publicFiles, this.privateFiles), totalSize);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        SkinLibraryManager.Client client = SkinLibraryManager.getClient();
        client.setSetting(this.setting);
        client.getPublicSkinLibrary().reloadFiles(this.publicFiles);
        client.getPrivateSkinLibrary().reloadFiles(this.privateFiles);
    }

    private void writeCompressedBuffer(ByteBufOutputStream stream, Iterable<SkinLibraryFile> files, int totalSize) {
        try {
            stream.writeInt(totalSize);
            DataOutputStream dataStream = new DataOutputStream(new GZIPOutputStream((OutputStream)stream));
            IOutputStream outputStream = IOutputStream.of(dataStream);
            for (SkinLibraryFile file : files) {
                SkinProperties properties = ObjectUtils.safeCast(file.getSkinProperties(), SkinProperties.class);
                outputStream.writeString(file.getPath());
                outputStream.writeBoolean(properties == null);
                if (properties == null) continue;
                outputStream.writeType(file.getSkinType());
                outputStream.writeInt(file.getSkinVersion());
                outputStream.writeInt(file.getLastModified());
                properties.writeToStream(outputStream);
            }
            dataStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Iterable<SkinLibraryFile> readCompressedBuffer(ByteBufInputStream stream) {
        ArrayList<SkinLibraryFile> files = new ArrayList<SkinLibraryFile>();
        try {
            int totalSize = stream.readInt();
            DataInputStream dataStream = new DataInputStream(new GZIPInputStream((InputStream)stream));
            IInputStream inputStream = IInputStream.of(dataStream);
            for (int index = 0; index < totalSize; ++index) {
                String path = inputStream.readString();
                String basename = SkinFileUtils.getBaseName(path);
                if (inputStream.readBoolean()) {
                    files.add(new SkinLibraryFile(DataDomain.DEDICATED_SERVER, basename, path));
                    continue;
                }
                ISkinType skinType = inputStream.readType(SkinTypes::byName);
                int fileVersion = inputStream.readInt();
                int lastModified = inputStream.readInt();
                SkinProperties properties = new SkinProperties();
                properties.readFromStream(inputStream);
                SkinFileHeader header = SkinFileHeader.of(fileVersion, skinType, properties);
                header.setLastModified(lastModified);
                files.add(new SkinLibraryFile(DataDomain.DEDICATED_SERVER, basename, path, header));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }
}

