/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import moe.plushie.armourers_workshop.init.ModConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemMatcher {
    private final Pattern pattern;
    private final Collection<String> whitelist;
    private final Collection<String> blacklist;
    private final Predicate<ItemStack> requirements;

    public ItemMatcher(String regex, Collection<String> whitelist, Collection<String> blacklist, Predicate<ItemStack> requirements) {
        this.pattern = Pattern.compile(regex, 2);
        this.whitelist = whitelist;
        this.blacklist = blacklist;
        this.requirements = requirements;
    }

    public boolean test(ResourceLocation registryName, ItemStack itemStack) {
        String id = registryName.toString();
        if (this.whitelist.contains(id)) {
            return true;
        }
        if (!ModConfig.Common.enableMatchingByItemId) {
            return false;
        }
        if (ModConfig.Common.disableMatchingItems.contains(id) || this.blacklist.contains(id)) {
            return false;
        }
        if (this.pattern.matcher(registryName.func_110623_a()).find()) {
            return this.requirements == null || this.requirements.test(itemStack);
        }
        return false;
    }
}

