/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.ThreadUtils;
import net.minecraft.network.PacketBuffer;

public class PacketSplitter {
    private final int SPLIT_BODY_FLAG = -1;
    private final int SPLIT_BEGIN_FLAG = -2;
    private final int SPLIT_END_FLAG = -3;
    private final HashMap<UUID, ArrayList<ByteBuf>> receivedBuffers = new HashMap();
    private final ExecutorService workThread = ThreadUtils.newFixedThreadPool(2, "AW-NET/N-ED");

    public <T> void split(CustomPacket message, Function<PacketBuffer, T> builder, int partSize, Consumer<T> consumer) {
        this.workThread.submit(() -> {
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            this.writePacket(message, buffer);
            buffer.capacity(buffer.readableBytes());
            int bufferSize = buffer.readableBytes();
            if (bufferSize <= partSize) {
                Object packet = builder.apply(buffer);
                consumer.accept(packet);
                return;
            }
            for (int index = 0; index < bufferSize; index += partSize) {
                ByteBuf partPrefix = Unpooled.buffer((int)4);
                if (index == 0) {
                    partPrefix.writeInt(-2);
                } else if (index + partSize >= bufferSize) {
                    partPrefix.writeInt(-3);
                } else {
                    partPrefix.writeInt(-1);
                }
                int resolvedPartSize = Math.min(bufferSize - index, partSize);
                ByteBuf buffer1 = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{partPrefix, buffer.retainedSlice(buffer.readerIndex(), resolvedPartSize)});
                buffer.skipBytes(resolvedPartSize);
                Object packet = builder.apply(new PacketBuffer(buffer1));
                consumer.accept(packet);
            }
            buffer.release();
        });
    }

    public void merge(UUID uuid, PacketBuffer buffer, Consumer<CustomPacket> consumer) {
        int packetState = buffer.getInt(0);
        if (packetState < 0) {
            ArrayList playerReceivedBuffers = this.receivedBuffers.computeIfAbsent(uuid, k -> new ArrayList());
            if (packetState == -2 && !playerReceivedBuffers.isEmpty()) {
                ModLog.warn("aw2:split received out of order - inbound buffer not empty when receiving first", new Object[0]);
                playerReceivedBuffers.clear();
            }
            buffer.skipBytes(4);
            playerReceivedBuffers.add(buffer.retainedDuplicate());
            if (packetState == -3) {
                this.workThread.submit(() -> {
                    PacketBuffer full = new PacketBuffer(Unpooled.wrappedBuffer((ByteBuf[])playerReceivedBuffers.toArray(new ByteBuf[0])));
                    playerReceivedBuffers.clear();
                    consumer.accept(this.readPacket(full));
                    full.release();
                });
            }
            return;
        }
        if (buffer.readableBytes() < 3000) {
            consumer.accept(this.readPacket(buffer));
            return;
        }
        ByteBuf receivedBuf = buffer.retainedDuplicate();
        this.workThread.submit(() -> {
            consumer.accept(this.readPacket(new PacketBuffer(receivedBuf)));
            receivedBuf.release();
        });
    }

    private void writePacket(CustomPacket message, PacketBuffer buffer) {
        buffer.writeInt(message.getPacketID());
        message.encode(buffer);
    }

    private CustomPacket readPacket(PacketBuffer buffer) {
        int packetId = buffer.readInt();
        Function<PacketBuffer, CustomPacket> decoder = CustomPacket.getPacketType(packetId);
        if (decoder != null) {
            return decoder.apply(buffer);
        }
        throw new UnsupportedOperationException("This packet ( " + packetId + ") does not support in this version.");
    }
}

